package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.merchant.MerchantIncrementListReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantIncrementListResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantCategoryListReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantCategoryListResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantListReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantListResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendCommunityReportXiaoUFailMsgReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendCommunityReportXiaoUFailMsgResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantBindingUserAndHelperReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantBindingUserAndHelperResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendSystemMessageReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendSystemMessageResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryAccountInfoReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryAccountInfoResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentInfoReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentInfoResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentsResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 查询素材库增量列表
 * @author: 777771
 * @date: 2021-37-12 15:37:30
 */
public class MerchantService extends BaseService {

    public MerchantService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询素材库增量列表
     *
     * @author 777771
     * @createDate 2021-37-12 15:37:30
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantIncrementListResBean> incrementList(BaseRequest<MerchantIncrementListReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/material/incrementList", req);
    }
    /**
    * 方法的功能描述: 查询素材库增量列表
    *
    * @author 777771
    * @createDate 2021-37-12 15:37:30
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantIncrementListResBean> incrementList(String url,BaseRequest<MerchantIncrementListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询素材库分类列表
     *
     * @author 777771
     * @createDate 2021-35-11 14:35:13
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantCategoryListResBean> categoryList(BaseRequest<MerchantCategoryListReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/material/categoryList", req);
    }
    /**
    * 方法的功能描述: 查询素材库分类列表
    *
    * @author 777771
    * @createDate 2021-35-11 14:35:13
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantCategoryListResBean> categoryList(String url,BaseRequest<MerchantCategoryListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询素材库列表
     *
     * @author 777771
     * @createDate 2021-47-08 10:47:13
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantListResBean> list(BaseRequest<MerchantListReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/material/list", req);
    }
    /**
    * 方法的功能描述: 查询素材库列表
    *
    * @author 777771
    * @createDate 2021-47-08 10:47:13
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantListResBean> list(String url,BaseRequest<MerchantListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 小U - 小助手封号或者异常时调用接口
     *
     * @author 777771
     * @createDate 2020-23-13 16:23:31
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantSendCommunityReportXiaoUFailMsgResBean> sendCommunityReportXiaoUFailMsg(BaseRequest<MerchantSendCommunityReportXiaoUFailMsgReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/community/sendCommunityReportXiaoUFailMsg", req);
    }
    /**
    * 方法的功能描述: 小U - 小助手封号或者异常时调用接口
    *
    * @author 777771
    * @createDate 2020-23-13 16:23:31
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantSendCommunityReportXiaoUFailMsgResBean> sendCommunityReportXiaoUFailMsg(String url,BaseRequest<MerchantSendCommunityReportXiaoUFailMsgReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 小U - 绑定用户和小助手信息
     *
     * @author 777771
     * @createDate 2020-32-13 16:32:44
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantBindingUserAndHelperResBean> bindingUserAndHelper(BaseRequest<MerchantBindingUserAndHelperReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/community/bindingUserAndHelper", req);
    }
    /**
    * 方法的功能描述: 小U - 绑定用户和小助手信息
    *
    * @author 777771
    * @createDate 2020-32-13 16:32:44
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantBindingUserAndHelperResBean> bindingUserAndHelper(String url,BaseRequest<MerchantBindingUserAndHelperReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 营销通app推送消息
     *
     * @author 777771
     * @createDate 2018-53-26 12:53:42
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantSendSystemMessageResBean> sendSystemMessage(BaseRequest<MerchantSendSystemMessageReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/sendSystemMessage", req);
    }
    /**
    * 方法的功能描述: 营销通app推送消息
    *
    * @author 777771
    * @createDate 2018-53-26 12:53:42
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantSendSystemMessageResBean> sendSystemMessage(String url,BaseRequest<MerchantSendSystemMessageReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询账号信息
     *
     * @author 3742
     * @createDate 2018-02-12 13:02:08
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryAccountInfoResBean> queryAccountInfo(BaseRequest<MerchantQueryAccountInfoReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryAccountInfo", req);
    }
    /**
    * 方法的功能描述: 查询账号信息
    *
    * @author 3742
    * @createDate 2018-02-12 13:02:08
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantQueryAccountInfoResBean> queryAccountInfo(String url,BaseRequest<MerchantQueryAccountInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询大区办事处信息
     *
     * @author 3742
     * @createDate 2018-15-12 13:15:04
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryDepartmentInfoResBean> queryDepartmentInfo(BaseRequest<MerchantQueryDepartmentInfoReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryDepartmentInfo", req);
    }
    /**
    * 方法的功能描述: 查询大区办事处信息
    *
    * @author 3742
    * @createDate 2018-15-12 13:15:04
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantQueryDepartmentInfoResBean> queryDepartmentInfo(String url,BaseRequest<MerchantQueryDepartmentInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 查询大区办事处列表
     *
     * @author 3742
     * @createDate 2018-41-12 13:41:48
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryDepartmentsResBean> queryDepartments(BaseRequest<Void> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryDepartments", req);
    }
    /**
    * 方法的功能描述: 查询大区办事处列表
    *
    * @author 3742
    * @createDate 2018-41-12 13:41:48
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchantQueryDepartmentsResBean> queryDepartments(String url,BaseRequest<Void> req) throws BaseException {
         return call(url, req);
    }


}
