package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.merchandise.MerchandiseListReqBean;
import global.hh.openapi.sdk.api.bean.merchandise.MerchandiseListResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 批量查询sku商品明细
 * @author: 777771
 * @date: 2021-44-15 11:44:53
 */
public class MerchandiseService extends BaseService {

    public MerchandiseService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询sku商品明细
     *
     * @author 777771
     * @createDate 2021-44-15 11:44:53
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchandiseListResBean> list(BaseRequest<MerchandiseListReqBean> req) throws BaseException {
        return call("merchandise-web/open/merchandise/sku/list", req);
    }
    /**
    * 方法的功能描述: 查询sku商品明细
    *
    * @author 777771
    * @createDate 2021-44-15 11:44:53
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<MerchandiseListResBean> list(String url,BaseRequest<MerchandiseListReqBean> req) throws BaseException {
         return call(url, req);
    }


}
