package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.logistics.LogisticsReceiveJDLogisticsReqBean;
import global.hh.openapi.sdk.api.bean.logistics.LogisticsReceiveJDLogisticsResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 提供给京东、荣庆等 物流信息推送
 * @author: 777771
 * @date: 2021-42-24 13:42:56
 */
public class LogisticsService extends BaseService {

    public LogisticsService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 接收物流推送信息
     *
     * @author 777771
     * @createDate 2021-42-24 13:42:56
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<LogisticsReceiveJDLogisticsResBean> receiveJDLogistics(BaseRequest<LogisticsReceiveJDLogisticsReqBean> req) throws BaseException {
        return call("dealer-platform-logistics/logistics/receiveJDLogistics", req);
    }
    /**
    * 方法的功能描述: 接收物流推送信息
    *
    * @author 777771
    * @createDate 2021-42-24 13:42:56
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<LogisticsReceiveJDLogisticsResBean> receiveJDLogistics(String url,BaseRequest<LogisticsReceiveJDLogisticsReqBean> req) throws BaseException {
         return call(url, req);
    }


}
