package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.hcm.HcmGetDepartmentListReqBean;
import global.hh.openapi.sdk.api.bean.hcm.HcmGetUserListReqBean;
import global.hh.openapi.sdk.api.bean.hcm.HcmGetUserListResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 获取组织架构信息
 * @author: 777771
 * @date: 2023-42-27 13:42:20
 */
public class HcmService extends BaseService {

    public HcmService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: HCM组织架构
     *
     * @author 777771
     * @createDate 2023-42-27 13:42:20
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<Void> getDepartmentList(BaseRequest<HcmGetDepartmentListReqBean> req) throws BaseException {
        return call("account-service/hcm/getDepartmentList", req);
    }
    /**
    * 方法的功能描述: HCM组织架构
    *
    * @author 777771
    * @createDate 2023-42-27 13:42:20
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<Void> getDepartmentList(String url,BaseRequest<HcmGetDepartmentListReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取HCM用户信息
     *
     * @author 777771
     * @createDate 2023-27-27 14:27:39
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<HcmGetUserListResBean> getUserList(BaseRequest<HcmGetUserListReqBean> req) throws BaseException {
        return call("account-service/hcm/getUserList", req);
    }
    /**
    * 方法的功能描述: 获取HCM用户信息
    *
    * @author 777771
    * @createDate 2023-27-27 14:27:39
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<HcmGetUserListResBean> getUserList(String url,BaseRequest<HcmGetUserListReqBean> req) throws BaseException {
         return call(url, req);
    }


}
