package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteGetReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteGetResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteNoticeReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteNoticeResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteCorpReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteCorpResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteTextcardReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteTextcardResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteByCodeReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteByCodeResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteInfoReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteInfoResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteAgentReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteAgentResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteDetailReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteDetailResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteTextReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteTextResBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteCodeReqBean;
import global.hh.openapi.sdk.api.bean.corpbasicoutsite.CorpbasicoutsiteCodeResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 获取临时素材[素材链接最多保存5天]
 * @author: 777771
 * @date: 2023-04-03 11:04:47
 */
public class CorpBasicOutsiteService extends BaseService {

    public CorpBasicOutsiteService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 获取临时素材[素材链接最多保存5天]
     *
     * @author 777771
     * @createDate 2023-04-03 11:04:47
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteGetResBean> get(BaseRequest<CorpbasicoutsiteGetReqBean> req) throws BaseException {
        return call("corp-basic-outsite/media/get", req);
    }
    /**
    * 方法的功能描述: 获取临时素材[素材链接最多保存5天]
    *
    * @author 777771
    * @createDate 2023-04-03 11:04:47
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteGetResBean> get(String url,BaseRequest<CorpbasicoutsiteGetReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 发送小程序通知消息
     *
     * @author 777771
     * @createDate 2022-44-07 15:44:20
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteNoticeResBean> notice(BaseRequest<CorpbasicoutsiteNoticeReqBean> req) throws BaseException {
        return call("corp-basic-outsite/message/send/miniprogram/notice", req);
    }
    /**
    * 方法的功能描述: 发送小程序通知消息
    *
    * @author 777771
    * @createDate 2022-44-07 15:44:20
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteNoticeResBean> notice(String url,BaseRequest<CorpbasicoutsiteNoticeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取企业的jsapi_ticket
     *
     * @author 777771
     * @createDate 2022-24-17 16:24:47
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteCorpResBean> corp(BaseRequest<CorpbasicoutsiteCorpReqBean> req) throws BaseException {
        return call("corp-basic-outsite/jsapiticket/corp", req);
    }
    /**
    * 方法的功能描述: 获取企业的jsapi_ticket
    *
    * @author 777771
    * @createDate 2022-24-17 16:24:47
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteCorpResBean> corp(String url,BaseRequest<CorpbasicoutsiteCorpReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 发送应用文本卡片消息
     *
     * @author 777771
     * @createDate 2022-39-20 16:39:26
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteTextcardResBean> textcard(BaseRequest<CorpbasicoutsiteTextcardReqBean> req) throws BaseException {
        return call("corp-basic-outsite/message/send/textcard", req);
    }
    /**
    * 方法的功能描述: 发送应用文本卡片消息
    *
    * @author 777771
    * @createDate 2022-39-20 16:39:26
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteTextcardResBean> textcard(String url,BaseRequest<CorpbasicoutsiteTextcardReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 自建小程序获取访问用户身份
     *
     * @author 777771
     * @createDate 2022-37-28 09:37:16
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteByCodeResBean> byCode(BaseRequest<CorpbasicoutsiteByCodeReqBean> req) throws BaseException {
        return call("corp-basic-outsite/user/agentminiapp/by/code", req);
    }
    /**
    * 方法的功能描述: 自建小程序获取访问用户身份
    *
    * @author 777771
    * @createDate 2022-37-28 09:37:16
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteByCodeResBean> byCode(String url,BaseRequest<CorpbasicoutsiteByCodeReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 内部小程序获取访问用户身份
     *
     * @author 777771
     * @createDate 2021-49-15 13:49:54
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteInfoResBean> info(BaseRequest<CorpbasicoutsiteInfoReqBean> req) throws BaseException {
        return call("corp-basic/agent/miniapp/user/info", req);
    }
    /**
    * 方法的功能描述: 内部小程序获取访问用户身份
    *
    * @author 777771
    * @createDate 2021-49-15 13:49:54
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteInfoResBean> info(String url,BaseRequest<CorpbasicoutsiteInfoReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取应用的jsapi_ticket
     *
     * @author 777771
     * @createDate 2021-32-02 14:32:13
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteAgentResBean> agent(BaseRequest<CorpbasicoutsiteAgentReqBean> req) throws BaseException {
        return call("corp-basic-outsite/jsapiticket/agent", req);
    }
    /**
    * 方法的功能描述: 获取应用的jsapi_ticket
    *
    * @author 777771
    * @createDate 2021-32-02 14:32:13
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteAgentResBean> agent(String url,BaseRequest<CorpbasicoutsiteAgentReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 读取成员详情
     *
     * @author 777771
     * @createDate 2020-31-20 16:31:19
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteDetailResBean> detail(BaseRequest<CorpbasicoutsiteDetailReqBean> req) throws BaseException {
        return call("corp-basic-outsite/user/detail", req);
    }
    /**
    * 方法的功能描述: 读取成员详情
    *
    * @author 777771
    * @createDate 2020-31-20 16:31:19
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteDetailResBean> detail(String url,BaseRequest<CorpbasicoutsiteDetailReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 发送应用文本消息
     *
     * @author 777771
     * @createDate 2021-17-26 09:17:32
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteTextResBean> text(BaseRequest<CorpbasicoutsiteTextReqBean> req) throws BaseException {
        return call("corp-basic-outsite/message/send/text", req);
    }
    /**
    * 方法的功能描述: 发送应用文本消息
    *
    * @author 777771
    * @createDate 2021-17-26 09:17:32
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteTextResBean> text(String url,BaseRequest<CorpbasicoutsiteTextReqBean> req) throws BaseException {
         return call(url, req);
    }

    /**
     * 方法的功能描述: 获取访问用户身份
     *
     * @author 777771
     * @createDate 2020-37-20 16:37:20
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CorpbasicoutsiteCodeResBean> code(BaseRequest<CorpbasicoutsiteCodeReqBean> req) throws BaseException {
        return call("corp-basic-outsite/user/get/by/code", req);
    }
    /**
    * 方法的功能描述: 获取访问用户身份
    *
    * @author 777771
    * @createDate 2020-37-20 16:37:20
    * @param url 请求的URL 可指定
    * @param req 请求的业务对象
    * @return 响应的业务数据
    */
    public BaseResponse<CorpbasicoutsiteCodeResBean> code(String url,BaseRequest<CorpbasicoutsiteCodeReqBean> req) throws BaseException {
         return call(url, req);
    }


}
