package global.hh.openapi.sdk.api.bean.member;


/**
 * @description: 公共接口：根据手机号码注册会员，不判断是否为新客。
 * @author: 777771
 * @date: 2020-00-24 16:00:06
 */
public class MemberSyncCommonNewCustomerV2ReqBean {
    /**
     * 手机号码，必填。
     */
    private String mobile;

    /**
     * 类型，此处传固定值type=1。必填。
     */
    private Long type;

    /**
     * 顾客性别，-1-性别不详，0-男，1-女
     */
    private Long gender;

    /**
     * 顾客姓名，建议填写。
     */
    private String name;

    /**
     * 宝宝生日时间戳(毫秒)，如无则不需传这个参数。
     */
    private Long birthday;

    /**
     * 宝宝名称，如无则不需传这个参数。
     */
    private String kidName;

    /**
     * 来源，与商家约定传参。此处传固定值 fromSystem = “POS”。
     */
    private String fromSystem;

    /**
     * 品牌名称， 与商家约定传参。格式为：品牌名称（大写字母）+”SHM”。 例如： YOUZAN_SHM 。
     */
    private String fromSubSystem;

    /**
     * 此处传customerId=0，或者不传。
     */
    private Long customerId;

    public MemberSyncCommonNewCustomerV2ReqBean(){
    }

    public MemberSyncCommonNewCustomerV2ReqBean(String mobile,Long type,Long gender,String name,Long birthday,String kidName,String fromSystem,String fromSubSystem,Long customerId){
        this.mobile=mobile;
        this.type=type;
        this.gender=gender;
        this.name=name;
        this.birthday=birthday;
        this.kidName=kidName;
        this.fromSystem=fromSystem;
        this.fromSubSystem=fromSubSystem;
        this.customerId=customerId;
    }

    private String getMobile() {
        return mobile;
    }

    private void setMobile(String mobile) {
        this.mobile = mobile;
    }
    private Long getType() {
        return type;
    }

    private void setType(Long type) {
        this.type = type;
    }
    private Long getGender() {
        return gender;
    }

    private void setGender(Long gender) {
        this.gender = gender;
    }
    private String getName() {
        return name;
    }

    private void setName(String name) {
        this.name = name;
    }
    private Long getBirthday() {
        return birthday;
    }

    private void setBirthday(Long birthday) {
        this.birthday = birthday;
    }
    private String getKidName() {
        return kidName;
    }

    private void setKidName(String kidName) {
        this.kidName = kidName;
    }
    private String getFromSystem() {
        return fromSystem;
    }

    private void setFromSystem(String fromSystem) {
        this.fromSystem = fromSystem;
    }
    private String getFromSubSystem() {
        return fromSubSystem;
    }

    private void setFromSubSystem(String fromSubSystem) {
        this.fromSubSystem = fromSubSystem;
    }
    private Long getCustomerId() {
        return customerId;
    }

    private void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
}
