package global.hh.openapi.sdk.api.bean.member;


/**
 * @description: 对外暴露api接口
 * @author: 777771
 * @date: 2019-37-26 21:37:55
 */
public class MemberCallFinishSceneInstanceBean {

    /**
     * 通话实例索引
     */
    private Long callIndex;

    /**
     * 通话记录Id
     */
    private Long callInstanceId;

    /**
     * 任务Id
     */
    private Long callJobId;

    /**
     * 外呼方式，对应主叫号码(线路)类型枚举
     */
    private Long callType;

    /**
     * 主叫用户ID
     */
    private Long callUserId;

    /**
     * 是否回调完成 0：未回调 1：已回调
     */
    private Long callbacked;

    /**
     * 主叫号码
     */
    private String callerPhone;

    /**
     * 通话轮次
     */
    private Long chatRound;

    /**
     * 公司ID
     */
    private Long companyId;

    /**
     * 通话费用，单位（分）
     */
    private Long cost;

    /**
     * 客户Id
     */
    private Long customerId;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户手机号
     */
    private String customerTelephone;

    /**
     * 通话时长
     */
    private Long duration;

    /**
     * 通话结束时间
     */
    private String endTime;

    /**
     * 已完成通话状态枚举，通话完成最终状态，0	已接听1拒接2	无法接通3主叫号码不可用4空号5关机6占线7停机8未接9主叫欠费10	呼损11黑名单
     */
    private Long finishStatus;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 修改时间
     */
    private String gmtModified;

    /**
     * 话术名
     */
    private String handlePerson;

    /**
     * 挂机人 0：AI 1：用户
     */
    private Long hangUp;

    /**
     * 所属行业
     */
    private String industry;

    /**
     * 电话任务名称
     */
    private String jobName;

    /**
     * 通话录音（包含Ai和客户）
     */
    private String luyinOssUrl;

    /**
     * 通话记录携带的参数(json字符串)，包含话术变量和自定义参数，用户可以传入自己的变量，百应回调会传回给用户
     */
    private String properties;

    /**
     * 是否已读，产品中的通话记录已读未读状态 0：未读 1：已读
     */
    private Long readStatus;

    /**
     * 机器人Id
     */
    private Long robotDefId;

    /**
     * 场景Id
     */
    private Long sceneDefId;

    /**
     * 场景录音id
     */
    private Long sceneRecordId;

    /**
     * 二次拨打时间
     */
    private String secondaryCallTime;

    /**
     * 二次拨打次数 为0后不进行外呼
     */
    private Long secondaryCallTimes;

    /**
     * 通话开始时间
     */
    private String startTime;

    /**
     * 通话实例状态枚举，0未开始1进行中2已完成
     */
    private Long status;

    /**
     * bug追踪结果
     */
    private String trackResult;

    /**
     * 通话录音（只包含客户）
     */
    private String userLuyinOssUrl;

    public MemberCallFinishSceneInstanceBean(){
    }

    public MemberCallFinishSceneInstanceBean(Long callIndex,Long callInstanceId,Long callJobId,Long callType,Long callUserId,Long callbacked,String callerPhone,Long chatRound,Long companyId,Long cost,Long customerId,String customerName,String customerTelephone,Long duration,String endTime,Long finishStatus,String gmtCreate,String gmtModified,String handlePerson,Long hangUp,String industry,String jobName,String luyinOssUrl,String properties,Long readStatus,Long robotDefId,Long sceneDefId,Long sceneRecordId,String secondaryCallTime,Long secondaryCallTimes,String startTime,Long status,String trackResult,String userLuyinOssUrl){
        this.callIndex=callIndex;
        this.callInstanceId=callInstanceId;
        this.callJobId=callJobId;
        this.callType=callType;
        this.callUserId=callUserId;
        this.callbacked=callbacked;
        this.callerPhone=callerPhone;
        this.chatRound=chatRound;
        this.companyId=companyId;
        this.cost=cost;
        this.customerId=customerId;
        this.customerName=customerName;
        this.customerTelephone=customerTelephone;
        this.duration=duration;
        this.endTime=endTime;
        this.finishStatus=finishStatus;
        this.gmtCreate=gmtCreate;
        this.gmtModified=gmtModified;
        this.handlePerson=handlePerson;
        this.hangUp=hangUp;
        this.industry=industry;
        this.jobName=jobName;
        this.luyinOssUrl=luyinOssUrl;
        this.properties=properties;
        this.readStatus=readStatus;
        this.robotDefId=robotDefId;
        this.sceneDefId=sceneDefId;
        this.sceneRecordId=sceneRecordId;
        this.secondaryCallTime=secondaryCallTime;
        this.secondaryCallTimes=secondaryCallTimes;
        this.startTime=startTime;
        this.status=status;
        this.trackResult=trackResult;
        this.userLuyinOssUrl=userLuyinOssUrl;
    }

    private Long getCallIndex() {
        return callIndex;
    }

    private void setCallIndex(Long callIndex) {
        this.callIndex = callIndex;
    }
    private Long getCallInstanceId() {
        return callInstanceId;
    }

    private void setCallInstanceId(Long callInstanceId) {
        this.callInstanceId = callInstanceId;
    }
    private Long getCallJobId() {
        return callJobId;
    }

    private void setCallJobId(Long callJobId) {
        this.callJobId = callJobId;
    }
    private Long getCallType() {
        return callType;
    }

    private void setCallType(Long callType) {
        this.callType = callType;
    }
    private Long getCallUserId() {
        return callUserId;
    }

    private void setCallUserId(Long callUserId) {
        this.callUserId = callUserId;
    }
    private Long getCallbacked() {
        return callbacked;
    }

    private void setCallbacked(Long callbacked) {
        this.callbacked = callbacked;
    }
    private String getCallerPhone() {
        return callerPhone;
    }

    private void setCallerPhone(String callerPhone) {
        this.callerPhone = callerPhone;
    }
    private Long getChatRound() {
        return chatRound;
    }

    private void setChatRound(Long chatRound) {
        this.chatRound = chatRound;
    }
    private Long getCompanyId() {
        return companyId;
    }

    private void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    private Long getCost() {
        return cost;
    }

    private void setCost(Long cost) {
        this.cost = cost;
    }
    private Long getCustomerId() {
        return customerId;
    }

    private void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    private String getCustomerName() {
        return customerName;
    }

    private void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    private String getCustomerTelephone() {
        return customerTelephone;
    }

    private void setCustomerTelephone(String customerTelephone) {
        this.customerTelephone = customerTelephone;
    }
    private Long getDuration() {
        return duration;
    }

    private void setDuration(Long duration) {
        this.duration = duration;
    }
    private String getEndTime() {
        return endTime;
    }

    private void setEndTime(String endTime) {
        this.endTime = endTime;
    }
    private Long getFinishStatus() {
        return finishStatus;
    }

    private void setFinishStatus(Long finishStatus) {
        this.finishStatus = finishStatus;
    }
    private String getGmtCreate() {
        return gmtCreate;
    }

    private void setGmtCreate(String gmtCreate) {
        this.gmtCreate = gmtCreate;
    }
    private String getGmtModified() {
        return gmtModified;
    }

    private void setGmtModified(String gmtModified) {
        this.gmtModified = gmtModified;
    }
    private String getHandlePerson() {
        return handlePerson;
    }

    private void setHandlePerson(String handlePerson) {
        this.handlePerson = handlePerson;
    }
    private Long getHangUp() {
        return hangUp;
    }

    private void setHangUp(Long hangUp) {
        this.hangUp = hangUp;
    }
    private String getIndustry() {
        return industry;
    }

    private void setIndustry(String industry) {
        this.industry = industry;
    }
    private String getJobName() {
        return jobName;
    }

    private void setJobName(String jobName) {
        this.jobName = jobName;
    }
    private String getLuyinOssUrl() {
        return luyinOssUrl;
    }

    private void setLuyinOssUrl(String luyinOssUrl) {
        this.luyinOssUrl = luyinOssUrl;
    }
    private String getProperties() {
        return properties;
    }

    private void setProperties(String properties) {
        this.properties = properties;
    }
    private Long getReadStatus() {
        return readStatus;
    }

    private void setReadStatus(Long readStatus) {
        this.readStatus = readStatus;
    }
    private Long getRobotDefId() {
        return robotDefId;
    }

    private void setRobotDefId(Long robotDefId) {
        this.robotDefId = robotDefId;
    }
    private Long getSceneDefId() {
        return sceneDefId;
    }

    private void setSceneDefId(Long sceneDefId) {
        this.sceneDefId = sceneDefId;
    }
    private Long getSceneRecordId() {
        return sceneRecordId;
    }

    private void setSceneRecordId(Long sceneRecordId) {
        this.sceneRecordId = sceneRecordId;
    }
    private String getSecondaryCallTime() {
        return secondaryCallTime;
    }

    private void setSecondaryCallTime(String secondaryCallTime) {
        this.secondaryCallTime = secondaryCallTime;
    }
    private Long getSecondaryCallTimes() {
        return secondaryCallTimes;
    }

    private void setSecondaryCallTimes(Long secondaryCallTimes) {
        this.secondaryCallTimes = secondaryCallTimes;
    }
    private String getStartTime() {
        return startTime;
    }

    private void setStartTime(String startTime) {
        this.startTime = startTime;
    }
    private Long getStatus() {
        return status;
    }

    private void setStatus(Long status) {
        this.status = status;
    }
    private String getTrackResult() {
        return trackResult;
    }

    private void setTrackResult(String trackResult) {
        this.trackResult = trackResult;
    }
    private String getUserLuyinOssUrl() {
        return userLuyinOssUrl;
    }

    private void setUserLuyinOssUrl(String userLuyinOssUrl) {
        this.userLuyinOssUrl = userLuyinOssUrl;
    }
}
