package global.hh.openapi.sdk.api.bean.member;


/**
 * @description: 添加会员的宝宝信息。需要先注册成为会员后才能添加。
 * @author: 777771
 * @date: 2021-02-17 15:02:37
 */
public class MemberAddCustKidReqBean {
    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 宝宝生日/预产期
     */
    private Long kidBirthday;

    /**
     * 宝宝姓名
     */
    private String kidName;

    /**
     * 宝宝性别，-1-性别未知，0-男，1-女。
     */
    private Long kidGender;

    /**
     * 宝宝奶量，如：50毫升
     */
    private String intake;

    /**
     * 1-纯奶粉，2-混合喂养，3-母乳
     */
    private Long feedWay;

    /**
     * 来源，约定传参。此处传固定值 fromSystem = “WEWORK”。
     */
    private String fromSystem;

    /**
     * 模块， 约定传参。格式为：模块名称（大写字母）+”_SHM”。 例如： PHONENUM_COLLECT 。
     */
    private String fromSubSystem;

    public MemberAddCustKidReqBean(){
    }

    public MemberAddCustKidReqBean(String mobile,Long kidBirthday,String kidName,Long kidGender,String intake,Long feedWay,String fromSystem,String fromSubSystem){
        this.mobile=mobile;
        this.kidBirthday=kidBirthday;
        this.kidName=kidName;
        this.kidGender=kidGender;
        this.intake=intake;
        this.feedWay=feedWay;
        this.fromSystem=fromSystem;
        this.fromSubSystem=fromSubSystem;
    }

    private String getMobile() {
        return mobile;
    }

    private void setMobile(String mobile) {
        this.mobile = mobile;
    }
    private Long getKidBirthday() {
        return kidBirthday;
    }

    private void setKidBirthday(Long kidBirthday) {
        this.kidBirthday = kidBirthday;
    }
    private String getKidName() {
        return kidName;
    }

    private void setKidName(String kidName) {
        this.kidName = kidName;
    }
    private Long getKidGender() {
        return kidGender;
    }

    private void setKidGender(Long kidGender) {
        this.kidGender = kidGender;
    }
    private String getIntake() {
        return intake;
    }

    private void setIntake(String intake) {
        this.intake = intake;
    }
    private Long getFeedWay() {
        return feedWay;
    }

    private void setFeedWay(Long feedWay) {
        this.feedWay = feedWay;
    }
    private String getFromSystem() {
        return fromSystem;
    }

    private void setFromSystem(String fromSystem) {
        this.fromSystem = fromSystem;
    }
    private String getFromSubSystem() {
        return fromSubSystem;
    }

    private void setFromSubSystem(String fromSubSystem) {
        this.fromSubSystem = fromSubSystem;
    }
}
