package global.hh.openapi.sdk.api.bean.corpbasicoutsite;


/**
 * @description: 企业微信发送应用文本消息
 * @author: 777771
 * @date: 2021-17-26 09:17:32
 */
public class CorpbasicoutsiteTextReqBean {
    /**
     * 自建应用id
     */
    private String agentId;

    /**
     * 消息内容，最长不超过2048个字节，超过将截断
     */
    private String content;

    /**
     * 部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数
     */
    private String toParty;

    /**
     * 成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送
     */
    private String toUser;

    public CorpbasicoutsiteTextReqBean(){
    }

    public CorpbasicoutsiteTextReqBean(String agentId,String content,String toParty,String toUser){
        this.agentId=agentId;
        this.content=content;
        this.toParty=toParty;
        this.toUser=toUser;
    }

    private String getAgentId() {
        return agentId;
    }

    private void setAgentId(String agentId) {
        this.agentId = agentId;
    }
    private String getContent() {
        return content;
    }

    private void setContent(String content) {
        this.content = content;
    }
    private String getToParty() {
        return toParty;
    }

    private void setToParty(String toParty) {
        this.toParty = toParty;
    }
    private String getToUser() {
        return toUser;
    }

    private void setToUser(String toUser) {
        this.toUser = toUser;
    }
}
