package global.hh.openapi.sdk.api.bean.corpbasicoutsite;

        import java.util.List;

/**
 * @description: 发送应用消息，类型：小程序通知消息
 * @author: 777771
 * @date: 2022-44-07 15:44:20
 */
public class CorpbasicoutsiteNoticeReqBean {
    /**
     * 自建应用id
     */
    private String agentId;

    /**
     * 小程序appid，必须是与当前应用关联的小程序
     */
    private String appId;

    /**
     * 消息内容键值对，最多允许10个item
     */
    private List<CorpbasicoutsiteNoticeContentItemItem> contentItems;

    /**
     * 消息描述，长度限制4-12个汉字（支持id转译）
     */
    private String description;

    /**
     * 是否放大第一个content_item
     */
    private Boolean emphasisFirstItem;

    /**
     * 点击消息卡片后的小程序页面，仅限本小程序内的页面。该字段不填则消息点击后不跳转。
     */
    private String page;

    /**
     * 消息标题，长度限制4-12个汉字（支持id转译）
     */
    private String title;

    /**
     * 部门ID列表，多个接收者用‘|’分隔，最多支持100个。当touser为@all时忽略本参数
     */
    private String toParty;

    /**
     * 成员ID列表（消息接收者，多个接收者用‘|’分隔，最多支持1000个）。特殊情况：指定为@all，则向该企业应用的全部成员发送
     */
    private String toUser;

    public CorpbasicoutsiteNoticeReqBean(){
    }

    public CorpbasicoutsiteNoticeReqBean(String agentId,String appId,List<CorpbasicoutsiteNoticeContentItemItem> contentItems,String description,Boolean emphasisFirstItem,String page,String title,String toParty,String toUser){
        this.agentId=agentId;
        this.appId=appId;
        this.contentItems=contentItems;
        this.description=description;
        this.emphasisFirstItem=emphasisFirstItem;
        this.page=page;
        this.title=title;
        this.toParty=toParty;
        this.toUser=toUser;
    }

    private String getAgentId() {
        return agentId;
    }

    private void setAgentId(String agentId) {
        this.agentId = agentId;
    }
    private String getAppId() {
        return appId;
    }

    private void setAppId(String appId) {
        this.appId = appId;
    }
    private List<CorpbasicoutsiteNoticeContentItemItem> getContentItems() {
        return contentItems;
    }

    private void setContentItems(List<CorpbasicoutsiteNoticeContentItemItem> contentItems) {
        this.contentItems = contentItems;
    }
    private String getDescription() {
        return description;
    }

    private void setDescription(String description) {
        this.description = description;
    }
    private Boolean getEmphasisFirstItem() {
        return emphasisFirstItem;
    }

    private void setEmphasisFirstItem(Boolean emphasisFirstItem) {
        this.emphasisFirstItem = emphasisFirstItem;
    }
    private String getPage() {
        return page;
    }

    private void setPage(String page) {
        this.page = page;
    }
    private String getTitle() {
        return title;
    }

    private void setTitle(String title) {
        this.title = title;
    }
    private String getToParty() {
        return toParty;
    }

    private void setToParty(String toParty) {
        this.toParty = toParty;
    }
    private String getToUser() {
        return toUser;
    }

    private void setToUser(String toUser) {
        this.toUser = toUser;
    }
}
