package global.hh.openapi.sdk.api.base;

import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;
import global.hh.openapi.sdk.utils.JsonUtils;
import global.hh.openapi.sdk.utils.SignatureUtils;
import global.hh.openapi.sdk.utils.httpUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * Created with IntelliJ IDEA
 *
 * @description:
 * @author:3742
 * @date:2018-11-23 15:28
 */
public class BaseService {
    private Config config;

    public BaseService(Config config) {
        this.config = config;
    }


    public BaseResponse call(String uri, BaseRequest req) throws BaseException {
        //公共参数
        Map<String, Object> publicParams = buildPublicParams();

        //业务参数
        Map<String, Object> businessParams = null;
        if (req.getRequest() != null) {
            businessParams = JsonUtils.toMap(JsonUtils.toJson(req.getRequest()));
        }
        String signature = SignatureUtils.generateSignature(publicParams, businessParams, config.getSecretKey());
        String requestBody = buildRequestBody(publicParams, businessParams, signature);

        String jsonResult = httpUtils.doPost(config, config.getDomain() + uri, requestBody);

        return JsonUtils.toObject(jsonResult, BaseResponse.class);
    }

    private Map<String, Object> buildPublicParams() {
        Map<String, Object> publicParams = new HashMap<String, Object>(10);
        publicParams.put("seqNo", generateUUID());
        publicParams.put("accessKey", config.getAccessKey());
        publicParams.put("signMethod", config.getSignMethod());
        publicParams.put("timestamp", System.currentTimeMillis());
        publicParams.put("version", "1.0.0");
        return publicParams;
    }

    /**
     * 方法的功能描述: 构建调用接口的请求数据
     *
     * @param
     * @return
     * @author 3742
     * @createDate 2018-11-16 18:26
     */
    private String buildRequestBody(Map<String, Object> publicParams, Map<String, Object> businessParams, String signature) throws BaseException {
        //调用接口时需要传的请求数据
        Map<String, Object> requestParams = new HashMap<String, Object>(20);
        requestParams.putAll(publicParams);
        requestParams.put("sign", signature);
        if (businessParams != null && !businessParams.isEmpty()) {
            requestParams.put("request", businessParams);
        }
        //调用api接口传的数据
        String callApiBody = JsonUtils.toJson(requestParams);
        return callApiBody;
    }

    /**
     * 方法的功能描述: 生成32位随机数，根据UUID来生成
     *
     * @param
     * @return
     * @author 3742
     * @createDate 2018-11-23 15:47
     */
    public String generateUUID() {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        if (uuid.length() > 32) {
            uuid = uuid.substring(0, 32);
        }
        return uuid.toUpperCase();
    }
}
