package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryAccountInfoReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryAccountInfoResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentInfoReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentInfoResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendSystemMessageReqBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantSendSystemMessageResBean;
import global.hh.openapi.sdk.api.bean.merchant.MerchantQueryDepartmentsResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 查询登录人的账号基础信息，包含当前登录门店所在的大区办事处
 * @author: 3742
 * @date: 2018-02-12 13:02:08
 */
public class MerchantService extends BaseService {

    public MerchantService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 查询账号信息
     *
     * @author 3742
     * @createDate 2018-02-12 13:02:08
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryAccountInfoResBean> queryAccountInfo(BaseRequest<MerchantQueryAccountInfoReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryAccountInfo", req);
    }

    /**
     * 方法的功能描述: 查询大区办事处信息
     *
     * @author 3742
     * @createDate 2018-15-12 13:15:04
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryDepartmentInfoResBean> queryDepartmentInfo(BaseRequest<MerchantQueryDepartmentInfoReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryDepartmentInfo", req);
    }

    /**
     * 方法的功能描述: 营销通app推送消息
     *
     * @author 777771
     * @createDate 2018-53-26 12:53:42
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantSendSystemMessageResBean> sendSystemMessage(BaseRequest<MerchantSendSystemMessageReqBean> req) throws BaseException {
        return call("merchant-system/open/merchant/base/sendSystemMessage", req);
    }

    /**
     * 方法的功能描述: 查询大区办事处列表
     *
     * @author 3742
     * @createDate 2018-41-12 13:41:48
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MerchantQueryDepartmentsResBean> queryDepartments(BaseRequest<Void> req) throws BaseException {
        return call("merchant-system/open/merchant/base/queryDepartments", req);
    }


}
