package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.member.MemberCheckAndSyncNewCustomerReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckAndSyncNewCustomerResBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckIsNewCilentReqBean;
import global.hh.openapi.sdk.api.bean.member.MemberCheckIsNewCilentResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 根据手机号码判断是否为新客,且同步会员信息
 * @author: 777771
 * @date: 2018-23-17 14:23:40
 */
public class MemberService extends BaseService {

    public MemberService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 判断是否为新客且同步会员信息
     *
     * @author 777771
     * @createDate 2018-23-17 14:23:40
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberCheckAndSyncNewCustomerResBean> checkAndSyncNewCustomer(BaseRequest<MemberCheckAndSyncNewCustomerReqBean> req) throws BaseException {
        return call("consumer-cust/cust/checkAndSyncNewCustomer", req);
    }

    /**
     * 方法的功能描述: 判断是否为新客
     *
     * @author 777771
     * @createDate 2018-57-05 17:57:10
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<MemberCheckIsNewCilentResBean> checkIsNewCilent(BaseRequest<MemberCheckIsNewCilentReqBean> req) throws BaseException {
        return call("consumer-cust/cust/checkIsNewCilent", req);
    }


}
