package global.hh.openapi.sdk.api.service;

import global.hh.openapi.sdk.api.base.BaseRequest;
import global.hh.openapi.sdk.api.base.BaseResponse;
import global.hh.openapi.sdk.api.base.BaseService;
import global.hh.openapi.sdk.api.bean.coupon.CouponAbolishReqBean;
import global.hh.openapi.sdk.api.bean.coupon.CouponAbolishResBean;
import global.hh.openapi.sdk.api.bean.coupon.CouponSendReqBean;
import global.hh.openapi.sdk.api.bean.coupon.CouponSendResBean;
import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;

/**
 * @description: 根据用户手机号、优惠券编码收回优惠券
 * @author: 777771
 * @date: 2018-21-06 17:21:38
 */
public class CouponService extends BaseService {

    public CouponService(Config config) {
        super(config);
    }

    /**
     * 方法的功能描述: 收回优惠券
     *
     * @author 777771
     * @createDate 2018-21-06 17:21:38
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CouponAbolishResBean> abolish(BaseRequest<CouponAbolishReqBean> req) throws BaseException {
        return call("coupon-api/coupon/abolish", req);
    }

    /**
     * 方法的功能描述: 领取/发送优惠券
     *
     * @author 777771
     * @createDate 2018-18-06 17:18:41
     * @param req 请求的业务对象
     * @return 响应的业务数据
     */
    public BaseResponse<CouponSendResBean> send(BaseRequest<CouponSendReqBean> req) throws BaseException {
        return call("coupon-api/coupon/send", req);
    }


}
