/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.upload.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class PrepareFile {
    private final String path;
    private final Optional<String> contentType;
    private final long contentLength;

    private PrepareFile(String path, Optional<String> contentType, long contentLength) {
        this.path = path;
        this.contentType = contentType;
        this.contentLength = contentLength;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="content_type")
    public Optional<String> getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="content_length")
    public long getContentLength() {
        return this.contentLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PrepareFile && this.equalTo((PrepareFile)other);
    }

    private boolean equalTo(PrepareFile other) {
        return this.path.equals(other.path) && this.contentType.equals(other.contentType) && this.contentLength == other.contentLength;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.contentType, this.contentLength);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PathStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PathStage,
    ContentLengthStage,
    _FinalStage {
        private String path;
        private long contentLength;
        private Optional<String> contentType = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(PrepareFile other) {
            this.path(other.getPath());
            this.contentType(other.getContentType());
            this.contentLength(other.getContentLength());
            return this;
        }

        @Override
        @JsonSetter(value="path")
        public ContentLengthStage path(String path) {
            this.path = path;
            return this;
        }

        @Override
        @JsonSetter(value="content_length")
        public _FinalStage contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public _FinalStage contentType(String contentType) {
            this.contentType = Optional.of(contentType);
            return this;
        }

        @Override
        @JsonSetter(value="content_type", nulls=Nulls.SKIP)
        public _FinalStage contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public PrepareFile build() {
            return new PrepareFile(this.path, this.contentType, this.contentLength);
        }
    }

    public static interface _FinalStage {
        public PrepareFile build();

        public _FinalStage contentType(Optional<String> var1);

        public _FinalStage contentType(String var1);
    }

    public static interface ContentLengthStage {
        public _FinalStage contentLength(long var1);
    }

    public static interface PathStage {
        public ContentLengthStage path(String var1);

        public Builder from(PrepareFile var1);
    }
}

