/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.players.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.matchmaker.players.types.RegionStatistics;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameModeStatistics {
    private final long playerCount;
    private final Map<String, RegionStatistics> regions;

    private GameModeStatistics(long playerCount, Map<String, RegionStatistics> regions) {
        this.playerCount = playerCount;
        this.regions = regions;
    }

    @JsonProperty(value="player_count")
    public long getPlayerCount() {
        return this.playerCount;
    }

    @JsonProperty(value="regions")
    public Map<String, RegionStatistics> getRegions() {
        return this.regions;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameModeStatistics && this.equalTo((GameModeStatistics)other);
    }

    private boolean equalTo(GameModeStatistics other) {
        return this.playerCount == other.playerCount && this.regions.equals(other.regions);
    }

    public int hashCode() {
        return Objects.hash(this.playerCount, this.regions);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlayerCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PlayerCountStage,
    _FinalStage {
        private long playerCount;
        private Map<String, RegionStatistics> regions = new LinkedHashMap<String, RegionStatistics>();

        private Builder() {
        }

        @Override
        public Builder from(GameModeStatistics other) {
            this.playerCount(other.getPlayerCount());
            this.regions(other.getRegions());
            return this;
        }

        @Override
        @JsonSetter(value="player_count")
        public _FinalStage playerCount(long playerCount) {
            this.playerCount = playerCount;
            return this;
        }

        @Override
        public _FinalStage regions(String key, RegionStatistics value) {
            this.regions.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllRegions(Map<String, RegionStatistics> regions) {
            this.regions.putAll(regions);
            return this;
        }

        @Override
        @JsonSetter(value="regions", nulls=Nulls.SKIP)
        public _FinalStage regions(Map<String, RegionStatistics> regions) {
            this.regions.clear();
            this.regions.putAll(regions);
            return this;
        }

        @Override
        public GameModeStatistics build() {
            return new GameModeStatistics(this.playerCount, this.regions);
        }
    }

    public static interface _FinalStage {
        public GameModeStatistics build();

        public _FinalStage regions(Map<String, RegionStatistics> var1);

        public _FinalStage putAllRegions(Map<String, RegionStatistics> var1);

        public _FinalStage regions(String var1, RegionStatistics var2);
    }

    public static interface PlayerCountStage {
        public _FinalStage playerCount(long var1);

        public Builder from(GameModeStatistics var1);
    }
}

