/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JoinPortRange {
    private final int min;
    private final int max;

    private JoinPortRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @JsonProperty(value="min")
    public int getMin() {
        return this.min;
    }

    @JsonProperty(value="max")
    public int getMax() {
        return this.max;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JoinPortRange && this.equalTo((JoinPortRange)other);
    }

    private boolean equalTo(JoinPortRange other) {
        return this.min == other.min && this.max == other.max;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MinStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MinStage,
    MaxStage,
    _FinalStage {
        private int min;
        private int max;

        private Builder() {
        }

        @Override
        public Builder from(JoinPortRange other) {
            this.min(other.getMin());
            this.max(other.getMax());
            return this;
        }

        @Override
        @JsonSetter(value="min")
        public MaxStage min(int min) {
            this.min = min;
            return this;
        }

        @Override
        @JsonSetter(value="max")
        public _FinalStage max(int max) {
            this.max = max;
            return this;
        }

        @Override
        public JoinPortRange build() {
            return new JoinPortRange(this.min, this.max);
        }
    }

    public static interface _FinalStage {
        public JoinPortRange build();
    }

    public static interface MaxStage {
        public _FinalStage max(int var1);
    }

    public static interface MinStage {
        public MaxStage min(int var1);

        public Builder from(JoinPortRange var1);
    }
}

