/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.matchmaker.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.matchmaker.common.types.JoinPlayer;
import com.rivet.api.resources.matchmaker.common.types.JoinPort;
import com.rivet.api.resources.matchmaker.common.types.JoinRegion;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class JoinLobby {
    private final UUID lobbyId;
    private final JoinRegion region;
    private final Map<String, JoinPort> ports;
    private final JoinPlayer player;

    private JoinLobby(UUID lobbyId, JoinRegion region, Map<String, JoinPort> ports, JoinPlayer player) {
        this.lobbyId = lobbyId;
        this.region = region;
        this.ports = ports;
        this.player = player;
    }

    @JsonProperty(value="lobby_id")
    public UUID getLobbyId() {
        return this.lobbyId;
    }

    @JsonProperty(value="region")
    public JoinRegion getRegion() {
        return this.region;
    }

    @JsonProperty(value="ports")
    public Map<String, JoinPort> getPorts() {
        return this.ports;
    }

    @JsonProperty(value="player")
    public JoinPlayer getPlayer() {
        return this.player;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JoinLobby && this.equalTo((JoinLobby)other);
    }

    private boolean equalTo(JoinLobby other) {
        return this.lobbyId.equals(other.lobbyId) && this.region.equals(other.region) && this.ports.equals(other.ports) && this.player.equals(other.player);
    }

    public int hashCode() {
        return Objects.hash(this.lobbyId, this.region, this.ports, this.player);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LobbyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LobbyIdStage,
    RegionStage,
    PlayerStage,
    _FinalStage {
        private UUID lobbyId;
        private JoinRegion region;
        private JoinPlayer player;
        private Map<String, JoinPort> ports = new LinkedHashMap<String, JoinPort>();

        private Builder() {
        }

        @Override
        public Builder from(JoinLobby other) {
            this.lobbyId(other.getLobbyId());
            this.region(other.getRegion());
            this.ports(other.getPorts());
            this.player(other.getPlayer());
            return this;
        }

        @Override
        @JsonSetter(value="lobby_id")
        public RegionStage lobbyId(UUID lobbyId) {
            this.lobbyId = lobbyId;
            return this;
        }

        @Override
        @JsonSetter(value="region")
        public PlayerStage region(JoinRegion region) {
            this.region = region;
            return this;
        }

        @Override
        @JsonSetter(value="player")
        public _FinalStage player(JoinPlayer player) {
            this.player = player;
            return this;
        }

        @Override
        public _FinalStage ports(String key, JoinPort value) {
            this.ports.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllPorts(Map<String, JoinPort> ports) {
            this.ports.putAll(ports);
            return this;
        }

        @Override
        @JsonSetter(value="ports", nulls=Nulls.SKIP)
        public _FinalStage ports(Map<String, JoinPort> ports) {
            this.ports.clear();
            this.ports.putAll(ports);
            return this;
        }

        @Override
        public JoinLobby build() {
            return new JoinLobby(this.lobbyId, this.region, this.ports, this.player);
        }
    }

    public static interface _FinalStage {
        public JoinLobby build();

        public _FinalStage ports(Map<String, JoinPort> var1);

        public _FinalStage putAllPorts(Map<String, JoinPort> var1);

        public _FinalStage ports(String var1, JoinPort var2);
    }

    public static interface PlayerStage {
        public _FinalStage player(JoinPlayer var1);
    }

    public static interface RegionStage {
        public PlayerStage region(JoinRegion var1);
    }

    public static interface LobbyIdStage {
        public RegionStage lobbyId(UUID var1);

        public Builder from(JoinLobby var1);
    }
}

