/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.kv.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetOperationRequest {
    private final String key;
    private final Optional<String> watchIndex;
    private final Optional<UUID> namespaceId;

    private GetOperationRequest(String key, Optional<String> watchIndex, Optional<UUID> namespaceId) {
        this.key = key;
        this.watchIndex = watchIndex;
        this.namespaceId = namespaceId;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="watch_index")
    public Optional<String> getWatchIndex() {
        return this.watchIndex;
    }

    @JsonProperty(value="namespace_id")
    public Optional<UUID> getNamespaceId() {
        return this.namespaceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetOperationRequest && this.equalTo((GetOperationRequest)other);
    }

    private boolean equalTo(GetOperationRequest other) {
        return this.key.equals(other.key) && this.watchIndex.equals(other.watchIndex) && this.namespaceId.equals(other.namespaceId);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.watchIndex, this.namespaceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KeyStage,
    _FinalStage {
        private String key;
        private Optional<UUID> namespaceId = Optional.empty();
        private Optional<String> watchIndex = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetOperationRequest other) {
            this.key(other.getKey());
            this.watchIndex(other.getWatchIndex());
            this.namespaceId(other.getNamespaceId());
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public _FinalStage key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public _FinalStage namespaceId(UUID namespaceId) {
            this.namespaceId = Optional.of(namespaceId);
            return this;
        }

        @Override
        @JsonSetter(value="namespace_id", nulls=Nulls.SKIP)
        public _FinalStage namespaceId(Optional<UUID> namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        public _FinalStage watchIndex(String watchIndex) {
            this.watchIndex = Optional.of(watchIndex);
            return this;
        }

        @Override
        @JsonSetter(value="watch_index", nulls=Nulls.SKIP)
        public _FinalStage watchIndex(Optional<String> watchIndex) {
            this.watchIndex = watchIndex;
            return this;
        }

        @Override
        public GetOperationRequest build() {
            return new GetOperationRequest(this.key, this.watchIndex, this.namespaceId);
        }
    }

    public static interface _FinalStage {
        public GetOperationRequest build();

        public _FinalStage watchIndex(Optional<String> var1);

        public _FinalStage watchIndex(String var1);

        public _FinalStage namespaceId(Optional<UUID> var1);

        public _FinalStage namespaceId(UUID var1);
    }

    public static interface KeyStage {
        public _FinalStage key(String var1);

        public Builder from(GetOperationRequest var1);
    }
}

