/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.kv.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class DeleteBatchRequest {
    private final String keys;
    private final Optional<UUID> namespaceId;

    private DeleteBatchRequest(String keys, Optional<UUID> namespaceId) {
        this.keys = keys;
        this.namespaceId = namespaceId;
    }

    @JsonProperty(value="keys")
    public String getKeys() {
        return this.keys;
    }

    @JsonProperty(value="namespace_id")
    public Optional<UUID> getNamespaceId() {
        return this.namespaceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteBatchRequest && this.equalTo((DeleteBatchRequest)other);
    }

    private boolean equalTo(DeleteBatchRequest other) {
        return this.keys.equals(other.keys) && this.namespaceId.equals(other.namespaceId);
    }

    public int hashCode() {
        return Objects.hash(this.keys, this.namespaceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KeysStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KeysStage,
    _FinalStage {
        private String keys;
        private Optional<UUID> namespaceId = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(DeleteBatchRequest other) {
            this.keys(other.getKeys());
            this.namespaceId(other.getNamespaceId());
            return this;
        }

        @Override
        @JsonSetter(value="keys")
        public _FinalStage keys(String keys) {
            this.keys = keys;
            return this;
        }

        @Override
        public _FinalStage namespaceId(UUID namespaceId) {
            this.namespaceId = Optional.of(namespaceId);
            return this;
        }

        @Override
        @JsonSetter(value="namespace_id", nulls=Nulls.SKIP)
        public _FinalStage namespaceId(Optional<UUID> namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        public DeleteBatchRequest build() {
            return new DeleteBatchRequest(this.keys, this.namespaceId);
        }
    }

    public static interface _FinalStage {
        public DeleteBatchRequest build();

        public _FinalStage namespaceId(Optional<UUID> var1);

        public _FinalStage namespaceId(UUID var1);
    }

    public static interface KeysStage {
        public _FinalStage keys(String var1);

        public Builder from(DeleteBatchRequest var1);
    }
}

