/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.kv.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Entry {
    private final String key;
    private final Object value;
    private final Optional<Boolean> deleted;

    private Entry(String key, Object value, Optional<Boolean> deleted) {
        this.key = key;
        this.value = value;
        this.deleted = deleted;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @JsonProperty(value="deleted")
    public Optional<Boolean> getDeleted() {
        return this.deleted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Entry && this.equalTo((Entry)other);
    }

    private boolean equalTo(Entry other) {
        return this.key.equals(other.key) && this.value.equals(other.value) && this.deleted.equals(other.deleted);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.deleted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static KeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements KeyStage,
    ValueStage,
    _FinalStage {
        private String key;
        private Object value;
        private Optional<Boolean> deleted = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Entry other) {
            this.key(other.getKey());
            this.value(other.getValue());
            this.deleted(other.getDeleted());
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public ValueStage key(String key) {
            this.key = key;
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(Object value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage deleted(Boolean deleted) {
            this.deleted = Optional.of(deleted);
            return this;
        }

        @Override
        @JsonSetter(value="deleted", nulls=Nulls.SKIP)
        public _FinalStage deleted(Optional<Boolean> deleted) {
            this.deleted = deleted;
            return this;
        }

        @Override
        public Entry build() {
            return new Entry(this.key, this.value, this.deleted);
        }
    }

    public static interface _FinalStage {
        public Entry build();

        public _FinalStage deleted(Optional<Boolean> var1);

        public _FinalStage deleted(Boolean var1);
    }

    public static interface ValueStage {
        public _FinalStage value(Object var1);
    }

    public static interface KeyStage {
        public ValueStage key(String var1);

        public Builder from(Entry var1);
    }
}

