/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.identity.common.types.Summary;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetSummariesResponse {
    private final List<Summary> identities;
    private final WatchResponse watch;

    private GetSummariesResponse(List<Summary> identities, WatchResponse watch) {
        this.identities = identities;
        this.watch = watch;
    }

    @JsonProperty(value="identities")
    public List<Summary> getIdentities() {
        return this.identities;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetSummariesResponse && this.equalTo((GetSummariesResponse)other);
    }

    private boolean equalTo(GetSummariesResponse other) {
        return this.identities.equals(other.identities) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.identities, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private List<Summary> identities = new ArrayList<Summary>();

        private Builder() {
        }

        @Override
        public Builder from(GetSummariesResponse other) {
            this.identities(other.getIdentities());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage addAllIdentities(List<Summary> identities) {
            this.identities.addAll(identities);
            return this;
        }

        @Override
        public _FinalStage addIdentities(Summary identities) {
            this.identities.add(identities);
            return this;
        }

        @Override
        @JsonSetter(value="identities", nulls=Nulls.SKIP)
        public _FinalStage identities(List<Summary> identities) {
            this.identities.clear();
            this.identities.addAll(identities);
            return this;
        }

        @Override
        public GetSummariesResponse build() {
            return new GetSummariesResponse(this.identities, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetSummariesResponse build();

        public _FinalStage identities(List<Summary> var1);

        public _FinalStage addIdentities(Summary var1);

        public _FinalStage addAllIdentities(List<Summary> var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(GetSummariesResponse var1);
    }
}

