/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.links.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import com.rivet.api.resources.game.common.types.Handle;
import com.rivet.api.resources.identity.common.types.GameLinkStatus;
import com.rivet.api.resources.identity.links.types.GetGameLinkNewIdentity;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetGameLinkResponse {
    private final GameLinkStatus status;
    private final Handle game;
    private final com.rivet.api.resources.identity.common.types.Handle currentIdentity;
    private final Optional<GetGameLinkNewIdentity> newIdentity;
    private final WatchResponse watch;

    private GetGameLinkResponse(GameLinkStatus status, Handle game, com.rivet.api.resources.identity.common.types.Handle currentIdentity, Optional<GetGameLinkNewIdentity> newIdentity, WatchResponse watch) {
        this.status = status;
        this.game = game;
        this.currentIdentity = currentIdentity;
        this.newIdentity = newIdentity;
        this.watch = watch;
    }

    @JsonProperty(value="status")
    public GameLinkStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="game")
    public Handle getGame() {
        return this.game;
    }

    @JsonProperty(value="current_identity")
    public com.rivet.api.resources.identity.common.types.Handle getCurrentIdentity() {
        return this.currentIdentity;
    }

    @JsonProperty(value="new_identity")
    public Optional<GetGameLinkNewIdentity> getNewIdentity() {
        return this.newIdentity;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetGameLinkResponse && this.equalTo((GetGameLinkResponse)other);
    }

    private boolean equalTo(GetGameLinkResponse other) {
        return this.status.equals((Object)other.status) && this.game.equals(other.game) && this.currentIdentity.equals(other.currentIdentity) && this.newIdentity.equals(other.newIdentity) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.game, this.currentIdentity, this.newIdentity, this.watch});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StatusStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StatusStage,
    GameStage,
    CurrentIdentityStage,
    WatchStage,
    _FinalStage {
        private GameLinkStatus status;
        private Handle game;
        private com.rivet.api.resources.identity.common.types.Handle currentIdentity;
        private WatchResponse watch;
        private Optional<GetGameLinkNewIdentity> newIdentity = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetGameLinkResponse other) {
            this.status(other.getStatus());
            this.game(other.getGame());
            this.currentIdentity(other.getCurrentIdentity());
            this.newIdentity(other.getNewIdentity());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public GameStage status(GameLinkStatus status) {
            this.status = status;
            return this;
        }

        @Override
        @JsonSetter(value="game")
        public CurrentIdentityStage game(Handle game) {
            this.game = game;
            return this;
        }

        @Override
        @JsonSetter(value="current_identity")
        public WatchStage currentIdentity(com.rivet.api.resources.identity.common.types.Handle currentIdentity) {
            this.currentIdentity = currentIdentity;
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage newIdentity(GetGameLinkNewIdentity newIdentity) {
            this.newIdentity = Optional.of(newIdentity);
            return this;
        }

        @Override
        @JsonSetter(value="new_identity", nulls=Nulls.SKIP)
        public _FinalStage newIdentity(Optional<GetGameLinkNewIdentity> newIdentity) {
            this.newIdentity = newIdentity;
            return this;
        }

        @Override
        public GetGameLinkResponse build() {
            return new GetGameLinkResponse(this.status, this.game, this.currentIdentity, this.newIdentity, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetGameLinkResponse build();

        public _FinalStage newIdentity(Optional<GetGameLinkNewIdentity> var1);

        public _FinalStage newIdentity(GetGameLinkNewIdentity var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);
    }

    public static interface CurrentIdentityStage {
        public WatchStage currentIdentity(com.rivet.api.resources.identity.common.types.Handle var1);
    }

    public static interface GameStage {
        public CurrentIdentityStage game(Handle var1);
    }

    public static interface StatusStage {
        public GameStage status(GameLinkStatus var1);

        public Builder from(GetGameLinkResponse var1);
    }
}

