/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class UpdateGameActivity {
    private final Optional<String> message;
    private final Optional<Object> publicMetadata;
    private final Optional<Object> mutualMetadata;

    private UpdateGameActivity(Optional<String> message, Optional<Object> publicMetadata, Optional<Object> mutualMetadata) {
        this.message = message;
        this.publicMetadata = publicMetadata;
        this.mutualMetadata = mutualMetadata;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return this.message;
    }

    @JsonProperty(value="public_metadata")
    public Optional<Object> getPublicMetadata() {
        return this.publicMetadata;
    }

    @JsonProperty(value="mutual_metadata")
    public Optional<Object> getMutualMetadata() {
        return this.mutualMetadata;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateGameActivity && this.equalTo((UpdateGameActivity)other);
    }

    private boolean equalTo(UpdateGameActivity other) {
        return this.message.equals(other.message) && this.publicMetadata.equals(other.publicMetadata) && this.mutualMetadata.equals(other.mutualMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.publicMetadata, this.mutualMetadata);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> message = Optional.empty();
        private Optional<Object> publicMetadata = Optional.empty();
        private Optional<Object> mutualMetadata = Optional.empty();

        private Builder() {
        }

        public Builder from(UpdateGameActivity other) {
            this.message(other.getMessage());
            this.publicMetadata(other.getPublicMetadata());
            this.mutualMetadata(other.getMutualMetadata());
            return this;
        }

        @JsonSetter(value="message", nulls=Nulls.SKIP)
        public Builder message(Optional<String> message) {
            this.message = message;
            return this;
        }

        public Builder message(String message) {
            this.message = Optional.of(message);
            return this;
        }

        @JsonSetter(value="public_metadata", nulls=Nulls.SKIP)
        public Builder publicMetadata(Optional<Object> publicMetadata) {
            this.publicMetadata = publicMetadata;
            return this;
        }

        public Builder publicMetadata(Object publicMetadata) {
            this.publicMetadata = Optional.of(publicMetadata);
            return this;
        }

        @JsonSetter(value="mutual_metadata", nulls=Nulls.SKIP)
        public Builder mutualMetadata(Optional<Object> mutualMetadata) {
            this.mutualMetadata = mutualMetadata;
            return this;
        }

        public Builder mutualMetadata(Object mutualMetadata) {
            this.mutualMetadata = Optional.of(mutualMetadata);
            return this;
        }

        public UpdateGameActivity build() {
            return new UpdateGameActivity(this.message, this.publicMetadata, this.mutualMetadata);
        }
    }
}

