/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.EmailLinkedAccount;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LinkedAccount {
    private final Optional<EmailLinkedAccount> email;

    private LinkedAccount(Optional<EmailLinkedAccount> email) {
        this.email = email;
    }

    @JsonProperty(value="email")
    public Optional<EmailLinkedAccount> getEmail() {
        return this.email;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LinkedAccount && this.equalTo((LinkedAccount)other);
    }

    private boolean equalTo(LinkedAccount other) {
        return this.email.equals(other.email);
    }

    public int hashCode() {
        return Objects.hash(this.email);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<EmailLinkedAccount> email = Optional.empty();

        private Builder() {
        }

        public Builder from(LinkedAccount other) {
            this.email(other.getEmail());
            return this;
        }

        @JsonSetter(value="email", nulls=Nulls.SKIP)
        public Builder email(Optional<EmailLinkedAccount> email) {
            this.email = email;
            return this;
        }

        public Builder email(EmailLinkedAccount email) {
            this.email = Optional.of(email);
            return this;
        }

        public LinkedAccount build() {
            return new LinkedAccount(this.email);
        }
    }
}

