/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.ExternalLinks;
import com.rivet.api.resources.identity.common.types.Presence;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Handle {
    private final UUID identityId;
    private final String displayName;
    private final int accountNumber;
    private final String avatarUrl;
    private final Optional<Presence> presence;
    private final boolean isRegistered;
    private final ExternalLinks external;

    private Handle(UUID identityId, String displayName, int accountNumber, String avatarUrl, Optional<Presence> presence, boolean isRegistered, ExternalLinks external) {
        this.identityId = identityId;
        this.displayName = displayName;
        this.accountNumber = accountNumber;
        this.avatarUrl = avatarUrl;
        this.presence = presence;
        this.isRegistered = isRegistered;
        this.external = external;
    }

    @JsonProperty(value="identity_id")
    public UUID getIdentityId() {
        return this.identityId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="account_number")
    public int getAccountNumber() {
        return this.accountNumber;
    }

    @JsonProperty(value="avatar_url")
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    @JsonProperty(value="presence")
    public Optional<Presence> getPresence() {
        return this.presence;
    }

    @JsonProperty(value="is_registered")
    public boolean getIsRegistered() {
        return this.isRegistered;
    }

    @JsonProperty(value="external")
    public ExternalLinks getExternal() {
        return this.external;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Handle && this.equalTo((Handle)other);
    }

    private boolean equalTo(Handle other) {
        return this.identityId.equals(other.identityId) && this.displayName.equals(other.displayName) && this.accountNumber == other.accountNumber && this.avatarUrl.equals(other.avatarUrl) && this.presence.equals(other.presence) && this.isRegistered == other.isRegistered && this.external.equals(other.external);
    }

    public int hashCode() {
        return Objects.hash(this.identityId, this.displayName, this.accountNumber, this.avatarUrl, this.presence, this.isRegistered, this.external);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityIdStage,
    DisplayNameStage,
    AccountNumberStage,
    AvatarUrlStage,
    IsRegisteredStage,
    ExternalStage,
    _FinalStage {
        private UUID identityId;
        private String displayName;
        private int accountNumber;
        private String avatarUrl;
        private boolean isRegistered;
        private ExternalLinks external;
        private Optional<Presence> presence = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Handle other) {
            this.identityId(other.getIdentityId());
            this.displayName(other.getDisplayName());
            this.accountNumber(other.getAccountNumber());
            this.avatarUrl(other.getAvatarUrl());
            this.presence(other.getPresence());
            this.isRegistered(other.getIsRegistered());
            this.external(other.getExternal());
            return this;
        }

        @Override
        @JsonSetter(value="identity_id")
        public DisplayNameStage identityId(UUID identityId) {
            this.identityId = identityId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public AccountNumberStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="account_number")
        public AvatarUrlStage accountNumber(int accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        @Override
        @JsonSetter(value="avatar_url")
        public IsRegisteredStage avatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        @Override
        @JsonSetter(value="is_registered")
        public ExternalStage isRegistered(boolean isRegistered) {
            this.isRegistered = isRegistered;
            return this;
        }

        @Override
        @JsonSetter(value="external")
        public _FinalStage external(ExternalLinks external) {
            this.external = external;
            return this;
        }

        @Override
        public _FinalStage presence(Presence presence) {
            this.presence = Optional.of(presence);
            return this;
        }

        @Override
        @JsonSetter(value="presence", nulls=Nulls.SKIP)
        public _FinalStage presence(Optional<Presence> presence) {
            this.presence = presence;
            return this;
        }

        @Override
        public Handle build() {
            return new Handle(this.identityId, this.displayName, this.accountNumber, this.avatarUrl, this.presence, this.isRegistered, this.external);
        }
    }

    public static interface _FinalStage {
        public Handle build();

        public _FinalStage presence(Optional<Presence> var1);

        public _FinalStage presence(Presence var1);
    }

    public static interface ExternalStage {
        public _FinalStage external(ExternalLinks var1);
    }

    public static interface IsRegisteredStage {
        public ExternalStage isRegistered(boolean var1);
    }

    public static interface AvatarUrlStage {
        public IsRegisteredStage avatarUrl(String var1);
    }

    public static interface AccountNumberStage {
        public AvatarUrlStage accountNumber(int var1);
    }

    public static interface DisplayNameStage {
        public AccountNumberStage displayName(String var1);
    }

    public static interface IdentityIdStage {
        public DisplayNameStage identityId(UUID var1);

        public Builder from(Handle var1);
    }
}

