/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GlobalEventChatRead {
    private final UUID threadId;
    private final OffsetDateTime readTs;

    private GlobalEventChatRead(UUID threadId, OffsetDateTime readTs) {
        this.threadId = threadId;
        this.readTs = readTs;
    }

    @JsonProperty(value="thread_id")
    public UUID getThreadId() {
        return this.threadId;
    }

    @JsonProperty(value="read_ts")
    public OffsetDateTime getReadTs() {
        return this.readTs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GlobalEventChatRead && this.equalTo((GlobalEventChatRead)other);
    }

    private boolean equalTo(GlobalEventChatRead other) {
        return this.threadId.equals(other.threadId) && this.readTs.equals(other.readTs);
    }

    public int hashCode() {
        return Objects.hash(this.threadId, this.readTs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ThreadIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ThreadIdStage,
    ReadTsStage,
    _FinalStage {
        private UUID threadId;
        private OffsetDateTime readTs;

        private Builder() {
        }

        @Override
        public Builder from(GlobalEventChatRead other) {
            this.threadId(other.getThreadId());
            this.readTs(other.getReadTs());
            return this;
        }

        @Override
        @JsonSetter(value="thread_id")
        public ReadTsStage threadId(UUID threadId) {
            this.threadId = threadId;
            return this;
        }

        @Override
        @JsonSetter(value="read_ts")
        public _FinalStage readTs(OffsetDateTime readTs) {
            this.readTs = readTs;
            return this;
        }

        @Override
        public GlobalEventChatRead build() {
            return new GlobalEventChatRead(this.threadId, this.readTs);
        }
    }

    public static interface _FinalStage {
        public GlobalEventChatRead build();
    }

    public static interface ReadTsStage {
        public _FinalStage readTs(OffsetDateTime var1);
    }

    public static interface ThreadIdStage {
        public ReadTsStage threadId(UUID var1);

        public Builder from(GlobalEventChatRead var1);
    }
}

