/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.identity.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ExternalLinks {
    private final String profile;
    private final Optional<String> settings;
    private final Optional<String> chat;

    private ExternalLinks(String profile, Optional<String> settings, Optional<String> chat) {
        this.profile = profile;
        this.settings = settings;
        this.chat = chat;
    }

    @JsonProperty(value="profile")
    public String getProfile() {
        return this.profile;
    }

    @JsonProperty(value="settings")
    public Optional<String> getSettings() {
        return this.settings;
    }

    @JsonProperty(value="chat")
    public Optional<String> getChat() {
        return this.chat;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExternalLinks && this.equalTo((ExternalLinks)other);
    }

    private boolean equalTo(ExternalLinks other) {
        return this.profile.equals(other.profile) && this.settings.equals(other.settings) && this.chat.equals(other.chat);
    }

    public int hashCode() {
        return Objects.hash(this.profile, this.settings, this.chat);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProfileStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProfileStage,
    _FinalStage {
        private String profile;
        private Optional<String> chat = Optional.empty();
        private Optional<String> settings = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(ExternalLinks other) {
            this.profile(other.getProfile());
            this.settings(other.getSettings());
            this.chat(other.getChat());
            return this;
        }

        @Override
        @JsonSetter(value="profile")
        public _FinalStage profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public _FinalStage chat(String chat) {
            this.chat = Optional.of(chat);
            return this;
        }

        @Override
        @JsonSetter(value="chat", nulls=Nulls.SKIP)
        public _FinalStage chat(Optional<String> chat) {
            this.chat = chat;
            return this;
        }

        @Override
        public _FinalStage settings(String settings) {
            this.settings = Optional.of(settings);
            return this;
        }

        @Override
        @JsonSetter(value="settings", nulls=Nulls.SKIP)
        public _FinalStage settings(Optional<String> settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public ExternalLinks build() {
            return new ExternalLinks(this.profile, this.settings, this.chat);
        }
    }

    public static interface _FinalStage {
        public ExternalLinks build();

        public _FinalStage settings(Optional<String> var1);

        public _FinalStage settings(String var1);

        public _FinalStage chat(Optional<String> var1);

        public _FinalStage chat(String var1);
    }

    public static interface ProfileStage {
        public _FinalStage profile(String var1);

        public Builder from(ExternalLinks var1);
    }
}

