/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SearchRequest {
    private final String query;
    private final Optional<String> anchor;
    private final Optional<Double> limit;

    private SearchRequest(String query, Optional<String> anchor, Optional<Double> limit) {
        this.query = query;
        this.anchor = anchor;
        this.limit = limit;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="anchor")
    public Optional<String> getAnchor() {
        return this.anchor;
    }

    @JsonProperty(value="limit")
    public Optional<Double> getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchRequest && this.equalTo((SearchRequest)other);
    }

    private boolean equalTo(SearchRequest other) {
        return this.query.equals(other.query) && this.anchor.equals(other.anchor) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.anchor, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QueryStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements QueryStage,
    _FinalStage {
        private String query;
        private Optional<Double> limit = Optional.empty();
        private Optional<String> anchor = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(SearchRequest other) {
            this.query(other.getQuery());
            this.anchor(other.getAnchor());
            this.limit(other.getLimit());
            return this;
        }

        @Override
        @JsonSetter(value="query")
        public _FinalStage query(String query) {
            this.query = query;
            return this;
        }

        @Override
        public _FinalStage limit(Double limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Double> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage anchor(String anchor) {
            this.anchor = Optional.of(anchor);
            return this;
        }

        @Override
        @JsonSetter(value="anchor", nulls=Nulls.SKIP)
        public _FinalStage anchor(Optional<String> anchor) {
            this.anchor = anchor;
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this.query, this.anchor, this.limit);
        }
    }

    public static interface _FinalStage {
        public SearchRequest build();

        public _FinalStage anchor(Optional<String> var1);

        public _FinalStage anchor(String var1);

        public _FinalStage limit(Optional<Double> var1);

        public _FinalStage limit(Double var1);
    }

    public static interface QueryStage {
        public _FinalStage query(String var1);

        public Builder from(SearchRequest var1);
    }
}

