/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class ExternalLinks {
    private final String profile;
    private final String chat;

    private ExternalLinks(String profile, String chat) {
        this.profile = profile;
        this.chat = chat;
    }

    @JsonProperty(value="profile")
    public String getProfile() {
        return this.profile;
    }

    @JsonProperty(value="chat")
    public String getChat() {
        return this.chat;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ExternalLinks && this.equalTo((ExternalLinks)other);
    }

    private boolean equalTo(ExternalLinks other) {
        return this.profile.equals(other.profile) && this.chat.equals(other.chat);
    }

    public int hashCode() {
        return Objects.hash(this.profile, this.chat);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProfileStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProfileStage,
    ChatStage,
    _FinalStage {
        private String profile;
        private String chat;

        private Builder() {
        }

        @Override
        public Builder from(ExternalLinks other) {
            this.profile(other.getProfile());
            this.chat(other.getChat());
            return this;
        }

        @Override
        @JsonSetter(value="profile")
        public ChatStage profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        @JsonSetter(value="chat")
        public _FinalStage chat(String chat) {
            this.chat = chat;
            return this;
        }

        @Override
        public ExternalLinks build() {
            return new ExternalLinks(this.profile, this.chat);
        }
    }

    public static interface _FinalStage {
        public ExternalLinks build();
    }

    public static interface ChatStage {
        public _FinalStage chat(String var1);
    }

    public static interface ProfileStage {
        public ChatStage profile(String var1);

        public Builder from(ExternalLinks var1);
    }
}

