/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.group.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.identity.common.types.Handle;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class BannedIdentity {
    private final Handle identity;
    private final OffsetDateTime banTs;

    private BannedIdentity(Handle identity, OffsetDateTime banTs) {
        this.identity = identity;
        this.banTs = banTs;
    }

    @JsonProperty(value="identity")
    public Handle getIdentity() {
        return this.identity;
    }

    @JsonProperty(value="ban_ts")
    public OffsetDateTime getBanTs() {
        return this.banTs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BannedIdentity && this.equalTo((BannedIdentity)other);
    }

    private boolean equalTo(BannedIdentity other) {
        return this.identity.equals(other.identity) && this.banTs.equals(other.banTs);
    }

    public int hashCode() {
        return Objects.hash(this.identity, this.banTs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityStage,
    BanTsStage,
    _FinalStage {
        private Handle identity;
        private OffsetDateTime banTs;

        private Builder() {
        }

        @Override
        public Builder from(BannedIdentity other) {
            this.identity(other.getIdentity());
            this.banTs(other.getBanTs());
            return this;
        }

        @Override
        @JsonSetter(value="identity")
        public BanTsStage identity(Handle identity) {
            this.identity = identity;
            return this;
        }

        @Override
        @JsonSetter(value="ban_ts")
        public _FinalStage banTs(OffsetDateTime banTs) {
            this.banTs = banTs;
            return this;
        }

        @Override
        public BannedIdentity build() {
            return new BannedIdentity(this.identity, this.banTs);
        }
    }

    public static interface _FinalStage {
        public BannedIdentity build();
    }

    public static interface BanTsStage {
        public _FinalStage banTs(OffsetDateTime var1);
    }

    public static interface IdentityStage {
        public BanTsStage identity(Handle var1);

        public Builder from(BannedIdentity var1);
    }
}

