/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.game.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Handle {
    private final UUID gameId;
    private final String nameId;
    private final String displayName;
    private final Optional<String> logoUrl;
    private final Optional<String> bannerUrl;

    private Handle(UUID gameId, String nameId, String displayName, Optional<String> logoUrl, Optional<String> bannerUrl) {
        this.gameId = gameId;
        this.nameId = nameId;
        this.displayName = displayName;
        this.logoUrl = logoUrl;
        this.bannerUrl = bannerUrl;
    }

    @JsonProperty(value="game_id")
    public UUID getGameId() {
        return this.gameId;
    }

    @JsonProperty(value="name_id")
    public String getNameId() {
        return this.nameId;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="logo_url")
    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty(value="banner_url")
    public Optional<String> getBannerUrl() {
        return this.bannerUrl;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Handle && this.equalTo((Handle)other);
    }

    private boolean equalTo(Handle other) {
        return this.gameId.equals(other.gameId) && this.nameId.equals(other.nameId) && this.displayName.equals(other.displayName) && this.logoUrl.equals(other.logoUrl) && this.bannerUrl.equals(other.bannerUrl);
    }

    public int hashCode() {
        return Objects.hash(this.gameId, this.nameId, this.displayName, this.logoUrl, this.bannerUrl);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GameIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GameIdStage,
    NameIdStage,
    DisplayNameStage,
    _FinalStage {
        private UUID gameId;
        private String nameId;
        private String displayName;
        private Optional<String> bannerUrl = Optional.empty();
        private Optional<String> logoUrl = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Handle other) {
            this.gameId(other.getGameId());
            this.nameId(other.getNameId());
            this.displayName(other.getDisplayName());
            this.logoUrl(other.getLogoUrl());
            this.bannerUrl(other.getBannerUrl());
            return this;
        }

        @Override
        @JsonSetter(value="game_id")
        public NameIdStage gameId(UUID gameId) {
            this.gameId = gameId;
            return this;
        }

        @Override
        @JsonSetter(value="name_id")
        public DisplayNameStage nameId(String nameId) {
            this.nameId = nameId;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public _FinalStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public _FinalStage bannerUrl(String bannerUrl) {
            this.bannerUrl = Optional.of(bannerUrl);
            return this;
        }

        @Override
        @JsonSetter(value="banner_url", nulls=Nulls.SKIP)
        public _FinalStage bannerUrl(Optional<String> bannerUrl) {
            this.bannerUrl = bannerUrl;
            return this;
        }

        @Override
        public _FinalStage logoUrl(String logoUrl) {
            this.logoUrl = Optional.of(logoUrl);
            return this;
        }

        @Override
        @JsonSetter(value="logo_url", nulls=Nulls.SKIP)
        public _FinalStage logoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        @Override
        public Handle build() {
            return new Handle(this.gameId, this.nameId, this.displayName, this.logoUrl, this.bannerUrl);
        }
    }

    public static interface _FinalStage {
        public Handle build();

        public _FinalStage logoUrl(Optional<String> var1);

        public _FinalStage logoUrl(String var1);

        public _FinalStage bannerUrl(Optional<String> var1);

        public _FinalStage bannerUrl(String var1);
    }

    public static interface DisplayNameStage {
        public _FinalStage displayName(String var1);
    }

    public static interface NameIdStage {
        public DisplayNameStage nameId(String var1);
    }

    public static interface GameIdStage {
        public NameIdStage gameId(UUID var1);

        public Builder from(Handle var1);
    }
}

