/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Summary {
    private final UUID versionId;
    private final OffsetDateTime createTs;
    private final String displayName;

    private Summary(UUID versionId, OffsetDateTime createTs, String displayName) {
        this.versionId = versionId;
        this.createTs = createTs;
        this.displayName = displayName;
    }

    @JsonProperty(value="version_id")
    public UUID getVersionId() {
        return this.versionId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Summary && this.equalTo((Summary)other);
    }

    private boolean equalTo(Summary other) {
        return this.versionId.equals(other.versionId) && this.createTs.equals(other.createTs) && this.displayName.equals(other.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.versionId, this.createTs, this.displayName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static VersionIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements VersionIdStage,
    CreateTsStage,
    DisplayNameStage,
    _FinalStage {
        private UUID versionId;
        private OffsetDateTime createTs;
        private String displayName;

        private Builder() {
        }

        @Override
        public Builder from(Summary other) {
            this.versionId(other.getVersionId());
            this.createTs(other.getCreateTs());
            this.displayName(other.getDisplayName());
            return this;
        }

        @Override
        @JsonSetter(value="version_id")
        public CreateTsStage versionId(UUID versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public DisplayNameStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public _FinalStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Summary build() {
            return new Summary(this.versionId, this.createTs, this.displayName);
        }
    }

    public static interface _FinalStage {
        public Summary build();
    }

    public static interface DisplayNameStage {
        public _FinalStage displayName(String var1);
    }

    public static interface CreateTsStage {
        public DisplayNameStage createTs(OffsetDateTime var1);
    }

    public static interface VersionIdStage {
        public CreateTsStage versionId(UUID var1);

        public Builder from(Summary var1);
    }
}

