/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.lobbygroup.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.PortProtocol;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.PortRange;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LobbyGroupRuntimeDockerPort {
    private final String label;
    private final Optional<Integer> targetPort;
    private final Optional<PortRange> portRange;
    private final PortProtocol proxyProtocol;

    private LobbyGroupRuntimeDockerPort(String label, Optional<Integer> targetPort, Optional<PortRange> portRange, PortProtocol proxyProtocol) {
        this.label = label;
        this.targetPort = targetPort;
        this.portRange = portRange;
        this.proxyProtocol = proxyProtocol;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="target_port")
    public Optional<Integer> getTargetPort() {
        return this.targetPort;
    }

    @JsonProperty(value="port_range")
    public Optional<PortRange> getPortRange() {
        return this.portRange;
    }

    @JsonProperty(value="proxy_protocol")
    public PortProtocol getProxyProtocol() {
        return this.proxyProtocol;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LobbyGroupRuntimeDockerPort && this.equalTo((LobbyGroupRuntimeDockerPort)other);
    }

    private boolean equalTo(LobbyGroupRuntimeDockerPort other) {
        return this.label.equals(other.label) && this.targetPort.equals(other.targetPort) && this.portRange.equals(other.portRange) && this.proxyProtocol.equals((Object)other.proxyProtocol);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.label, this.targetPort, this.portRange, this.proxyProtocol});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LabelStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LabelStage,
    ProxyProtocolStage,
    _FinalStage {
        private String label;
        private PortProtocol proxyProtocol;
        private Optional<PortRange> portRange = Optional.empty();
        private Optional<Integer> targetPort = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(LobbyGroupRuntimeDockerPort other) {
            this.label(other.getLabel());
            this.targetPort(other.getTargetPort());
            this.portRange(other.getPortRange());
            this.proxyProtocol(other.getProxyProtocol());
            return this;
        }

        @Override
        @JsonSetter(value="label")
        public ProxyProtocolStage label(String label) {
            this.label = label;
            return this;
        }

        @Override
        @JsonSetter(value="proxy_protocol")
        public _FinalStage proxyProtocol(PortProtocol proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
            return this;
        }

        @Override
        public _FinalStage portRange(PortRange portRange) {
            this.portRange = Optional.of(portRange);
            return this;
        }

        @Override
        @JsonSetter(value="port_range", nulls=Nulls.SKIP)
        public _FinalStage portRange(Optional<PortRange> portRange) {
            this.portRange = portRange;
            return this;
        }

        @Override
        public _FinalStage targetPort(Integer targetPort) {
            this.targetPort = Optional.of(targetPort);
            return this;
        }

        @Override
        @JsonSetter(value="target_port", nulls=Nulls.SKIP)
        public _FinalStage targetPort(Optional<Integer> targetPort) {
            this.targetPort = targetPort;
            return this;
        }

        @Override
        public LobbyGroupRuntimeDockerPort build() {
            return new LobbyGroupRuntimeDockerPort(this.label, this.targetPort, this.portRange, this.proxyProtocol);
        }
    }

    public static interface _FinalStage {
        public LobbyGroupRuntimeDockerPort build();

        public _FinalStage targetPort(Optional<Integer> var1);

        public _FinalStage targetPort(Integer var1);

        public _FinalStage portRange(Optional<PortRange> var1);

        public _FinalStage portRange(PortRange var1);
    }

    public static interface ProxyProtocolStage {
        public _FinalStage proxyProtocol(PortProtocol var1);
    }

    public static interface LabelStage {
        public ProxyProtocolStage label(String var1);

        public Builder from(LobbyGroupRuntimeDockerPort var1);
    }
}

