/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.lobbygroup.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LobbyGroupIdleLobbiesConfig {
    private final int minIdleLobbies;
    private final int maxIdleLobbies;

    private LobbyGroupIdleLobbiesConfig(int minIdleLobbies, int maxIdleLobbies) {
        this.minIdleLobbies = minIdleLobbies;
        this.maxIdleLobbies = maxIdleLobbies;
    }

    @JsonProperty(value="min_idle_lobbies")
    public int getMinIdleLobbies() {
        return this.minIdleLobbies;
    }

    @JsonProperty(value="max_idle_lobbies")
    public int getMaxIdleLobbies() {
        return this.maxIdleLobbies;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LobbyGroupIdleLobbiesConfig && this.equalTo((LobbyGroupIdleLobbiesConfig)other);
    }

    private boolean equalTo(LobbyGroupIdleLobbiesConfig other) {
        return this.minIdleLobbies == other.minIdleLobbies && this.maxIdleLobbies == other.maxIdleLobbies;
    }

    public int hashCode() {
        return Objects.hash(this.minIdleLobbies, this.maxIdleLobbies);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MinIdleLobbiesStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements MinIdleLobbiesStage,
    MaxIdleLobbiesStage,
    _FinalStage {
        private int minIdleLobbies;
        private int maxIdleLobbies;

        private Builder() {
        }

        @Override
        public Builder from(LobbyGroupIdleLobbiesConfig other) {
            this.minIdleLobbies(other.getMinIdleLobbies());
            this.maxIdleLobbies(other.getMaxIdleLobbies());
            return this;
        }

        @Override
        @JsonSetter(value="min_idle_lobbies")
        public MaxIdleLobbiesStage minIdleLobbies(int minIdleLobbies) {
            this.minIdleLobbies = minIdleLobbies;
            return this;
        }

        @Override
        @JsonSetter(value="max_idle_lobbies")
        public _FinalStage maxIdleLobbies(int maxIdleLobbies) {
            this.maxIdleLobbies = maxIdleLobbies;
            return this;
        }

        @Override
        public LobbyGroupIdleLobbiesConfig build() {
            return new LobbyGroupIdleLobbiesConfig(this.minIdleLobbies, this.maxIdleLobbies);
        }
    }

    public static interface _FinalStage {
        public LobbyGroupIdleLobbiesConfig build();
    }

    public static interface MaxIdleLobbiesStage {
        public _FinalStage maxIdleLobbies(int var1);
    }

    public static interface MinIdleLobbiesStage {
        public MaxIdleLobbiesStage minIdleLobbies(int var1);

        public Builder from(LobbyGroupIdleLobbiesConfig var1);
    }
}

