/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.gamemode.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.PortProtocol;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.PortRange;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.ProxyKind;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameModeRuntimeDockerPort {
    private final Optional<Integer> port;
    private final Optional<PortRange> portRange;
    private final Optional<PortProtocol> protocol;
    private final Optional<ProxyKind> proxy;
    private final Optional<Integer> devPort;
    private final Optional<PortRange> devPortRange;
    private final Optional<PortProtocol> devProtocol;

    private GameModeRuntimeDockerPort(Optional<Integer> port, Optional<PortRange> portRange, Optional<PortProtocol> protocol, Optional<ProxyKind> proxy, Optional<Integer> devPort, Optional<PortRange> devPortRange, Optional<PortProtocol> devProtocol) {
        this.port = port;
        this.portRange = portRange;
        this.protocol = protocol;
        this.proxy = proxy;
        this.devPort = devPort;
        this.devPortRange = devPortRange;
        this.devProtocol = devProtocol;
    }

    @JsonProperty(value="port")
    public Optional<Integer> getPort() {
        return this.port;
    }

    @JsonProperty(value="port_range")
    public Optional<PortRange> getPortRange() {
        return this.portRange;
    }

    @JsonProperty(value="protocol")
    public Optional<PortProtocol> getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="proxy")
    public Optional<ProxyKind> getProxy() {
        return this.proxy;
    }

    @JsonProperty(value="dev_port")
    public Optional<Integer> getDevPort() {
        return this.devPort;
    }

    @JsonProperty(value="dev_port_range")
    public Optional<PortRange> getDevPortRange() {
        return this.devPortRange;
    }

    @JsonProperty(value="dev_protocol")
    public Optional<PortProtocol> getDevProtocol() {
        return this.devProtocol;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameModeRuntimeDockerPort && this.equalTo((GameModeRuntimeDockerPort)other);
    }

    private boolean equalTo(GameModeRuntimeDockerPort other) {
        return this.port.equals(other.port) && this.portRange.equals(other.portRange) && this.protocol.equals(other.protocol) && this.proxy.equals(other.proxy) && this.devPort.equals(other.devPort) && this.devPortRange.equals(other.devPortRange) && this.devProtocol.equals(other.devProtocol);
    }

    public int hashCode() {
        return Objects.hash(this.port, this.portRange, this.protocol, this.proxy, this.devPort, this.devPortRange, this.devProtocol);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> port = Optional.empty();
        private Optional<PortRange> portRange = Optional.empty();
        private Optional<PortProtocol> protocol = Optional.empty();
        private Optional<ProxyKind> proxy = Optional.empty();
        private Optional<Integer> devPort = Optional.empty();
        private Optional<PortRange> devPortRange = Optional.empty();
        private Optional<PortProtocol> devProtocol = Optional.empty();

        private Builder() {
        }

        public Builder from(GameModeRuntimeDockerPort other) {
            this.port(other.getPort());
            this.portRange(other.getPortRange());
            this.protocol(other.getProtocol());
            this.proxy(other.getProxy());
            this.devPort(other.getDevPort());
            this.devPortRange(other.getDevPortRange());
            this.devProtocol(other.getDevProtocol());
            return this;
        }

        @JsonSetter(value="port", nulls=Nulls.SKIP)
        public Builder port(Optional<Integer> port) {
            this.port = port;
            return this;
        }

        public Builder port(Integer port) {
            this.port = Optional.of(port);
            return this;
        }

        @JsonSetter(value="port_range", nulls=Nulls.SKIP)
        public Builder portRange(Optional<PortRange> portRange) {
            this.portRange = portRange;
            return this;
        }

        public Builder portRange(PortRange portRange) {
            this.portRange = Optional.of(portRange);
            return this;
        }

        @JsonSetter(value="protocol", nulls=Nulls.SKIP)
        public Builder protocol(Optional<PortProtocol> protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder protocol(PortProtocol protocol) {
            this.protocol = Optional.of(protocol);
            return this;
        }

        @JsonSetter(value="proxy", nulls=Nulls.SKIP)
        public Builder proxy(Optional<ProxyKind> proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxy(ProxyKind proxy) {
            this.proxy = Optional.of(proxy);
            return this;
        }

        @JsonSetter(value="dev_port", nulls=Nulls.SKIP)
        public Builder devPort(Optional<Integer> devPort) {
            this.devPort = devPort;
            return this;
        }

        public Builder devPort(Integer devPort) {
            this.devPort = Optional.of(devPort);
            return this;
        }

        @JsonSetter(value="dev_port_range", nulls=Nulls.SKIP)
        public Builder devPortRange(Optional<PortRange> devPortRange) {
            this.devPortRange = devPortRange;
            return this;
        }

        public Builder devPortRange(PortRange devPortRange) {
            this.devPortRange = Optional.of(devPortRange);
            return this;
        }

        @JsonSetter(value="dev_protocol", nulls=Nulls.SKIP)
        public Builder devProtocol(Optional<PortProtocol> devProtocol) {
            this.devProtocol = devProtocol;
            return this;
        }

        public Builder devProtocol(PortProtocol devProtocol) {
            this.devProtocol = Optional.of(devProtocol);
            return this;
        }

        public GameModeRuntimeDockerPort build() {
            return new GameModeRuntimeDockerPort(this.port, this.portRange, this.protocol, this.proxy, this.devPort, this.devPortRange, this.devProtocol);
        }
    }
}

