/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.gamemode.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.gamemode.types.GameModeIdentityRequirement;
import com.rivet.api.resources.cloud.version.matchmaker.gamemode.types.GameModeVerificationConfig;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameModeFindConfig {
    private final boolean enabled;
    private final GameModeIdentityRequirement identityRequirement;
    private final Optional<GameModeVerificationConfig> verificationConfig;

    private GameModeFindConfig(boolean enabled, GameModeIdentityRequirement identityRequirement, Optional<GameModeVerificationConfig> verificationConfig) {
        this.enabled = enabled;
        this.identityRequirement = identityRequirement;
        this.verificationConfig = verificationConfig;
    }

    @JsonProperty(value="enabled")
    public boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="identity_requirement")
    public GameModeIdentityRequirement getIdentityRequirement() {
        return this.identityRequirement;
    }

    @JsonProperty(value="verification_config")
    public Optional<GameModeVerificationConfig> getVerificationConfig() {
        return this.verificationConfig;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameModeFindConfig && this.equalTo((GameModeFindConfig)other);
    }

    private boolean equalTo(GameModeFindConfig other) {
        return this.enabled == other.enabled && this.identityRequirement.equals((Object)other.identityRequirement) && this.verificationConfig.equals(other.verificationConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.identityRequirement, this.verificationConfig});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EnabledStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EnabledStage,
    IdentityRequirementStage,
    _FinalStage {
        private boolean enabled;
        private GameModeIdentityRequirement identityRequirement;
        private Optional<GameModeVerificationConfig> verificationConfig = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GameModeFindConfig other) {
            this.enabled(other.getEnabled());
            this.identityRequirement(other.getIdentityRequirement());
            this.verificationConfig(other.getVerificationConfig());
            return this;
        }

        @Override
        @JsonSetter(value="enabled")
        public IdentityRequirementStage enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        @JsonSetter(value="identity_requirement")
        public _FinalStage identityRequirement(GameModeIdentityRequirement identityRequirement) {
            this.identityRequirement = identityRequirement;
            return this;
        }

        @Override
        public _FinalStage verificationConfig(GameModeVerificationConfig verificationConfig) {
            this.verificationConfig = Optional.of(verificationConfig);
            return this;
        }

        @Override
        @JsonSetter(value="verification_config", nulls=Nulls.SKIP)
        public _FinalStage verificationConfig(Optional<GameModeVerificationConfig> verificationConfig) {
            this.verificationConfig = verificationConfig;
            return this;
        }

        @Override
        public GameModeFindConfig build() {
            return new GameModeFindConfig(this.enabled, this.identityRequirement, this.verificationConfig);
        }
    }

    public static interface _FinalStage {
        public GameModeFindConfig build();

        public _FinalStage verificationConfig(Optional<GameModeVerificationConfig> var1);

        public _FinalStage verificationConfig(GameModeVerificationConfig var1);
    }

    public static interface IdentityRequirementStage {
        public _FinalStage identityRequirement(GameModeIdentityRequirement var1);
    }

    public static interface EnabledStage {
        public IdentityRequirementStage enabled(boolean var1);

        public Builder from(GameModeFindConfig var1);
    }
}

