/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.gamemode.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.gamemode.types.GameModeIdentityRequirement;
import com.rivet.api.resources.cloud.version.matchmaker.gamemode.types.GameModeVerificationConfig;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameModeCreateConfig {
    private final GameModeIdentityRequirement identityRequirement;
    private final Optional<GameModeVerificationConfig> verificationConfig;
    private final boolean enablePublic;
    private final boolean enablePrivate;
    private final Optional<Integer> maxLobbiesPerIdentity;

    private GameModeCreateConfig(GameModeIdentityRequirement identityRequirement, Optional<GameModeVerificationConfig> verificationConfig, boolean enablePublic, boolean enablePrivate, Optional<Integer> maxLobbiesPerIdentity) {
        this.identityRequirement = identityRequirement;
        this.verificationConfig = verificationConfig;
        this.enablePublic = enablePublic;
        this.enablePrivate = enablePrivate;
        this.maxLobbiesPerIdentity = maxLobbiesPerIdentity;
    }

    @JsonProperty(value="identity_requirement")
    public GameModeIdentityRequirement getIdentityRequirement() {
        return this.identityRequirement;
    }

    @JsonProperty(value="verification_config")
    public Optional<GameModeVerificationConfig> getVerificationConfig() {
        return this.verificationConfig;
    }

    @JsonProperty(value="enable_public")
    public boolean getEnablePublic() {
        return this.enablePublic;
    }

    @JsonProperty(value="enable_private")
    public boolean getEnablePrivate() {
        return this.enablePrivate;
    }

    @JsonProperty(value="max_lobbies_per_identity")
    public Optional<Integer> getMaxLobbiesPerIdentity() {
        return this.maxLobbiesPerIdentity;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameModeCreateConfig && this.equalTo((GameModeCreateConfig)other);
    }

    private boolean equalTo(GameModeCreateConfig other) {
        return this.identityRequirement.equals((Object)other.identityRequirement) && this.verificationConfig.equals(other.verificationConfig) && this.enablePublic == other.enablePublic && this.enablePrivate == other.enablePrivate && this.maxLobbiesPerIdentity.equals(other.maxLobbiesPerIdentity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identityRequirement, this.verificationConfig, this.enablePublic, this.enablePrivate, this.maxLobbiesPerIdentity});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdentityRequirementStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdentityRequirementStage,
    EnablePublicStage,
    EnablePrivateStage,
    _FinalStage {
        private GameModeIdentityRequirement identityRequirement;
        private boolean enablePublic;
        private boolean enablePrivate;
        private Optional<Integer> maxLobbiesPerIdentity = Optional.empty();
        private Optional<GameModeVerificationConfig> verificationConfig = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GameModeCreateConfig other) {
            this.identityRequirement(other.getIdentityRequirement());
            this.verificationConfig(other.getVerificationConfig());
            this.enablePublic(other.getEnablePublic());
            this.enablePrivate(other.getEnablePrivate());
            this.maxLobbiesPerIdentity(other.getMaxLobbiesPerIdentity());
            return this;
        }

        @Override
        @JsonSetter(value="identity_requirement")
        public EnablePublicStage identityRequirement(GameModeIdentityRequirement identityRequirement) {
            this.identityRequirement = identityRequirement;
            return this;
        }

        @Override
        @JsonSetter(value="enable_public")
        public EnablePrivateStage enablePublic(boolean enablePublic) {
            this.enablePublic = enablePublic;
            return this;
        }

        @Override
        @JsonSetter(value="enable_private")
        public _FinalStage enablePrivate(boolean enablePrivate) {
            this.enablePrivate = enablePrivate;
            return this;
        }

        @Override
        public _FinalStage maxLobbiesPerIdentity(Integer maxLobbiesPerIdentity) {
            this.maxLobbiesPerIdentity = Optional.of(maxLobbiesPerIdentity);
            return this;
        }

        @Override
        @JsonSetter(value="max_lobbies_per_identity", nulls=Nulls.SKIP)
        public _FinalStage maxLobbiesPerIdentity(Optional<Integer> maxLobbiesPerIdentity) {
            this.maxLobbiesPerIdentity = maxLobbiesPerIdentity;
            return this;
        }

        @Override
        public _FinalStage verificationConfig(GameModeVerificationConfig verificationConfig) {
            this.verificationConfig = Optional.of(verificationConfig);
            return this;
        }

        @Override
        @JsonSetter(value="verification_config", nulls=Nulls.SKIP)
        public _FinalStage verificationConfig(Optional<GameModeVerificationConfig> verificationConfig) {
            this.verificationConfig = verificationConfig;
            return this;
        }

        @Override
        public GameModeCreateConfig build() {
            return new GameModeCreateConfig(this.identityRequirement, this.verificationConfig, this.enablePublic, this.enablePrivate, this.maxLobbiesPerIdentity);
        }
    }

    public static interface _FinalStage {
        public GameModeCreateConfig build();

        public _FinalStage verificationConfig(Optional<GameModeVerificationConfig> var1);

        public _FinalStage verificationConfig(GameModeVerificationConfig var1);

        public _FinalStage maxLobbiesPerIdentity(Optional<Integer> var1);

        public _FinalStage maxLobbiesPerIdentity(Integer var1);
    }

    public static interface EnablePrivateStage {
        public _FinalStage enablePrivate(boolean var1);
    }

    public static interface EnablePublicStage {
        public EnablePrivateStage enablePublic(boolean var1);
    }

    public static interface IdentityRequirementStage {
        public EnablePublicStage identityRequirement(GameModeIdentityRequirement var1);

        public Builder from(GameModeCreateConfig var1);
    }
}

