/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.version.matchmaker.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.CaptchaHcaptcha;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.CaptchaTurnstile;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class Captcha {
    private final int requestsBeforeReverify;
    private final long verificationTtl;
    private final Optional<CaptchaHcaptcha> hcaptcha;
    private final Optional<CaptchaTurnstile> turnstile;

    private Captcha(int requestsBeforeReverify, long verificationTtl, Optional<CaptchaHcaptcha> hcaptcha, Optional<CaptchaTurnstile> turnstile) {
        this.requestsBeforeReverify = requestsBeforeReverify;
        this.verificationTtl = verificationTtl;
        this.hcaptcha = hcaptcha;
        this.turnstile = turnstile;
    }

    @JsonProperty(value="requests_before_reverify")
    public int getRequestsBeforeReverify() {
        return this.requestsBeforeReverify;
    }

    @JsonProperty(value="verification_ttl")
    public long getVerificationTtl() {
        return this.verificationTtl;
    }

    @JsonProperty(value="hcaptcha")
    public Optional<CaptchaHcaptcha> getHcaptcha() {
        return this.hcaptcha;
    }

    @JsonProperty(value="turnstile")
    public Optional<CaptchaTurnstile> getTurnstile() {
        return this.turnstile;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Captcha && this.equalTo((Captcha)other);
    }

    private boolean equalTo(Captcha other) {
        return this.requestsBeforeReverify == other.requestsBeforeReverify && this.verificationTtl == other.verificationTtl && this.hcaptcha.equals(other.hcaptcha) && this.turnstile.equals(other.turnstile);
    }

    public int hashCode() {
        return Objects.hash(this.requestsBeforeReverify, this.verificationTtl, this.hcaptcha, this.turnstile);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RequestsBeforeReverifyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RequestsBeforeReverifyStage,
    VerificationTtlStage,
    _FinalStage {
        private int requestsBeforeReverify;
        private long verificationTtl;
        private Optional<CaptchaTurnstile> turnstile = Optional.empty();
        private Optional<CaptchaHcaptcha> hcaptcha = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(Captcha other) {
            this.requestsBeforeReverify(other.getRequestsBeforeReverify());
            this.verificationTtl(other.getVerificationTtl());
            this.hcaptcha(other.getHcaptcha());
            this.turnstile(other.getTurnstile());
            return this;
        }

        @Override
        @JsonSetter(value="requests_before_reverify")
        public VerificationTtlStage requestsBeforeReverify(int requestsBeforeReverify) {
            this.requestsBeforeReverify = requestsBeforeReverify;
            return this;
        }

        @Override
        @JsonSetter(value="verification_ttl")
        public _FinalStage verificationTtl(long verificationTtl) {
            this.verificationTtl = verificationTtl;
            return this;
        }

        @Override
        public _FinalStage turnstile(CaptchaTurnstile turnstile) {
            this.turnstile = Optional.of(turnstile);
            return this;
        }

        @Override
        @JsonSetter(value="turnstile", nulls=Nulls.SKIP)
        public _FinalStage turnstile(Optional<CaptchaTurnstile> turnstile) {
            this.turnstile = turnstile;
            return this;
        }

        @Override
        public _FinalStage hcaptcha(CaptchaHcaptcha hcaptcha) {
            this.hcaptcha = Optional.of(hcaptcha);
            return this;
        }

        @Override
        @JsonSetter(value="hcaptcha", nulls=Nulls.SKIP)
        public _FinalStage hcaptcha(Optional<CaptchaHcaptcha> hcaptcha) {
            this.hcaptcha = hcaptcha;
            return this;
        }

        @Override
        public Captcha build() {
            return new Captcha(this.requestsBeforeReverify, this.verificationTtl, this.hcaptcha, this.turnstile);
        }
    }

    public static interface _FinalStage {
        public Captcha build();

        public _FinalStage hcaptcha(Optional<CaptchaHcaptcha> var1);

        public _FinalStage hcaptcha(CaptchaHcaptcha var1);

        public _FinalStage turnstile(Optional<CaptchaTurnstile> var1);

        public _FinalStage turnstile(CaptchaTurnstile var1);
    }

    public static interface VerificationTtlStage {
        public _FinalStage verificationTtl(long var1);
    }

    public static interface RequestsBeforeReverifyStage {
        public VerificationTtlStage requestsBeforeReverify(int var1);

        public Builder from(Captcha var1);
    }
}

