/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.matchmaker.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.games.matchmaker.types.LogStream;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetLobbyLogsRequest {
    private final LogStream stream;
    private final Optional<String> watchIndex;

    private GetLobbyLogsRequest(LogStream stream, Optional<String> watchIndex) {
        this.stream = stream;
        this.watchIndex = watchIndex;
    }

    @JsonProperty(value="stream")
    public LogStream getStream() {
        return this.stream;
    }

    @JsonProperty(value="watch_index")
    public Optional<String> getWatchIndex() {
        return this.watchIndex;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetLobbyLogsRequest && this.equalTo((GetLobbyLogsRequest)other);
    }

    private boolean equalTo(GetLobbyLogsRequest other) {
        return this.stream.equals((Object)other.stream) && this.watchIndex.equals(other.watchIndex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.stream, this.watchIndex});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StreamStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StreamStage,
    _FinalStage {
        private LogStream stream;
        private Optional<String> watchIndex = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetLobbyLogsRequest other) {
            this.stream(other.getStream());
            this.watchIndex(other.getWatchIndex());
            return this;
        }

        @Override
        @JsonSetter(value="stream")
        public _FinalStage stream(LogStream stream) {
            this.stream = stream;
            return this;
        }

        @Override
        public _FinalStage watchIndex(String watchIndex) {
            this.watchIndex = Optional.of(watchIndex);
            return this;
        }

        @Override
        @JsonSetter(value="watch_index", nulls=Nulls.SKIP)
        public _FinalStage watchIndex(Optional<String> watchIndex) {
            this.watchIndex = watchIndex;
            return this;
        }

        @Override
        public GetLobbyLogsRequest build() {
            return new GetLobbyLogsRequest(this.stream, this.watchIndex);
        }
    }

    public static interface _FinalStage {
        public GetLobbyLogsRequest build();

        public _FinalStage watchIndex(Optional<String> var1);

        public _FinalStage watchIndex(String var1);
    }

    public static interface StreamStage {
        public _FinalStage stream(LogStream var1);

        public Builder from(GetLobbyLogsRequest var1);
    }
}

