/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.games.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GameLogoUploadPrepareRequest {
    private final String path;
    private final Optional<String> mime;
    private final long contentLength;

    private GameLogoUploadPrepareRequest(String path, Optional<String> mime, long contentLength) {
        this.path = path;
        this.mime = mime;
        this.contentLength = contentLength;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="mime")
    public Optional<String> getMime() {
        return this.mime;
    }

    @JsonProperty(value="content_length")
    public long getContentLength() {
        return this.contentLength;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GameLogoUploadPrepareRequest && this.equalTo((GameLogoUploadPrepareRequest)other);
    }

    private boolean equalTo(GameLogoUploadPrepareRequest other) {
        return this.path.equals(other.path) && this.mime.equals(other.mime) && this.contentLength == other.contentLength;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.mime, this.contentLength);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PathStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PathStage,
    ContentLengthStage,
    _FinalStage {
        private String path;
        private long contentLength;
        private Optional<String> mime = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GameLogoUploadPrepareRequest other) {
            this.path(other.getPath());
            this.mime(other.getMime());
            this.contentLength(other.getContentLength());
            return this;
        }

        @Override
        @JsonSetter(value="path")
        public ContentLengthStage path(String path) {
            this.path = path;
            return this;
        }

        @Override
        @JsonSetter(value="content_length")
        public _FinalStage contentLength(long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        @Override
        public _FinalStage mime(String mime) {
            this.mime = Optional.of(mime);
            return this;
        }

        @Override
        @JsonSetter(value="mime", nulls=Nulls.SKIP)
        public _FinalStage mime(Optional<String> mime) {
            this.mime = mime;
            return this;
        }

        @Override
        public GameLogoUploadPrepareRequest build() {
            return new GameLogoUploadPrepareRequest(this.path, this.mime, this.contentLength);
        }
    }

    public static interface _FinalStage {
        public GameLogoUploadPrepareRequest build();

        public _FinalStage mime(Optional<String> var1);

        public _FinalStage mime(String var1);
    }

    public static interface ContentLengthStage {
        public _FinalStage contentLength(long var1);
    }

    public static interface PathStage {
        public ContentLengthStage path(String var1);

        public Builder from(GameLogoUploadPrepareRequest var1);
    }
}

