/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.games.cdn.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.upload.common.types.PresignedRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CreateGameCdnSiteResponse {
    private final UUID siteId;
    private final UUID uploadId;
    private final List<PresignedRequest> presignedRequests;

    private CreateGameCdnSiteResponse(UUID siteId, UUID uploadId, List<PresignedRequest> presignedRequests) {
        this.siteId = siteId;
        this.uploadId = uploadId;
        this.presignedRequests = presignedRequests;
    }

    @JsonProperty(value="site_id")
    public UUID getSiteId() {
        return this.siteId;
    }

    @JsonProperty(value="upload_id")
    public UUID getUploadId() {
        return this.uploadId;
    }

    @JsonProperty(value="presigned_requests")
    public List<PresignedRequest> getPresignedRequests() {
        return this.presignedRequests;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateGameCdnSiteResponse && this.equalTo((CreateGameCdnSiteResponse)other);
    }

    private boolean equalTo(CreateGameCdnSiteResponse other) {
        return this.siteId.equals(other.siteId) && this.uploadId.equals(other.uploadId) && this.presignedRequests.equals(other.presignedRequests);
    }

    public int hashCode() {
        return Objects.hash(this.siteId, this.uploadId, this.presignedRequests);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SiteIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SiteIdStage,
    UploadIdStage,
    _FinalStage {
        private UUID siteId;
        private UUID uploadId;
        private List<PresignedRequest> presignedRequests = new ArrayList<PresignedRequest>();

        private Builder() {
        }

        @Override
        public Builder from(CreateGameCdnSiteResponse other) {
            this.siteId(other.getSiteId());
            this.uploadId(other.getUploadId());
            this.presignedRequests(other.getPresignedRequests());
            return this;
        }

        @Override
        @JsonSetter(value="site_id")
        public UploadIdStage siteId(UUID siteId) {
            this.siteId = siteId;
            return this;
        }

        @Override
        @JsonSetter(value="upload_id")
        public _FinalStage uploadId(UUID uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @Override
        public _FinalStage addAllPresignedRequests(List<PresignedRequest> presignedRequests) {
            this.presignedRequests.addAll(presignedRequests);
            return this;
        }

        @Override
        public _FinalStage addPresignedRequests(PresignedRequest presignedRequests) {
            this.presignedRequests.add(presignedRequests);
            return this;
        }

        @Override
        @JsonSetter(value="presigned_requests", nulls=Nulls.SKIP)
        public _FinalStage presignedRequests(List<PresignedRequest> presignedRequests) {
            this.presignedRequests.clear();
            this.presignedRequests.addAll(presignedRequests);
            return this;
        }

        @Override
        public CreateGameCdnSiteResponse build() {
            return new CreateGameCdnSiteResponse(this.siteId, this.uploadId, this.presignedRequests);
        }
    }

    public static interface _FinalStage {
        public CreateGameCdnSiteResponse build();

        public _FinalStage presignedRequests(List<PresignedRequest> var1);

        public _FinalStage addPresignedRequests(PresignedRequest var1);

        public _FinalStage addAllPresignedRequests(List<PresignedRequest> var1);
    }

    public static interface UploadIdStage {
        public _FinalStage uploadId(UUID var1);
    }

    public static interface SiteIdStage {
        public UploadIdStage siteId(UUID var1);

        public Builder from(CreateGameCdnSiteResponse var1);
    }
}

