/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.devices.links.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.common.types.WatchResponse;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetDeviceLinkResponse {
    private final Optional<String> cloudToken;
    private final WatchResponse watch;

    private GetDeviceLinkResponse(Optional<String> cloudToken, WatchResponse watch) {
        this.cloudToken = cloudToken;
        this.watch = watch;
    }

    @JsonProperty(value="cloud_token")
    public Optional<String> getCloudToken() {
        return this.cloudToken;
    }

    @JsonProperty(value="watch")
    public WatchResponse getWatch() {
        return this.watch;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetDeviceLinkResponse && this.equalTo((GetDeviceLinkResponse)other);
    }

    private boolean equalTo(GetDeviceLinkResponse other) {
        return this.cloudToken.equals(other.cloudToken) && this.watch.equals(other.watch);
    }

    public int hashCode() {
        return Objects.hash(this.cloudToken, this.watch);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WatchStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WatchStage,
    _FinalStage {
        private WatchResponse watch;
        private Optional<String> cloudToken = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetDeviceLinkResponse other) {
            this.cloudToken(other.getCloudToken());
            this.watch(other.getWatch());
            return this;
        }

        @Override
        @JsonSetter(value="watch")
        public _FinalStage watch(WatchResponse watch) {
            this.watch = watch;
            return this;
        }

        @Override
        public _FinalStage cloudToken(String cloudToken) {
            this.cloudToken = Optional.of(cloudToken);
            return this;
        }

        @Override
        @JsonSetter(value="cloud_token", nulls=Nulls.SKIP)
        public _FinalStage cloudToken(Optional<String> cloudToken) {
            this.cloudToken = cloudToken;
            return this;
        }

        @Override
        public GetDeviceLinkResponse build() {
            return new GetDeviceLinkResponse(this.cloudToken, this.watch);
        }
    }

    public static interface _FinalStage {
        public GetDeviceLinkResponse build();

        public _FinalStage cloudToken(Optional<String> var1);

        public _FinalStage cloudToken(String var1);
    }

    public static interface WatchStage {
        public _FinalStage watch(WatchResponse var1);

        public Builder from(GetDeviceLinkResponse var1);
    }
}

