/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.devices.links.requests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class GetDeviceLinkRequest {
    private final String deviceLinkToken;
    private final Optional<String> watchIndex;

    private GetDeviceLinkRequest(String deviceLinkToken, Optional<String> watchIndex) {
        this.deviceLinkToken = deviceLinkToken;
        this.watchIndex = watchIndex;
    }

    @JsonProperty(value="device_link_token")
    public String getDeviceLinkToken() {
        return this.deviceLinkToken;
    }

    @JsonProperty(value="watch_index")
    public Optional<String> getWatchIndex() {
        return this.watchIndex;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetDeviceLinkRequest && this.equalTo((GetDeviceLinkRequest)other);
    }

    private boolean equalTo(GetDeviceLinkRequest other) {
        return this.deviceLinkToken.equals(other.deviceLinkToken) && this.watchIndex.equals(other.watchIndex);
    }

    public int hashCode() {
        return Objects.hash(this.deviceLinkToken, this.watchIndex);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DeviceLinkTokenStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DeviceLinkTokenStage,
    _FinalStage {
        private String deviceLinkToken;
        private Optional<String> watchIndex = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(GetDeviceLinkRequest other) {
            this.deviceLinkToken(other.getDeviceLinkToken());
            this.watchIndex(other.getWatchIndex());
            return this;
        }

        @Override
        @JsonSetter(value="device_link_token")
        public _FinalStage deviceLinkToken(String deviceLinkToken) {
            this.deviceLinkToken = deviceLinkToken;
            return this;
        }

        @Override
        public _FinalStage watchIndex(String watchIndex) {
            this.watchIndex = Optional.of(watchIndex);
            return this;
        }

        @Override
        @JsonSetter(value="watch_index", nulls=Nulls.SKIP)
        public _FinalStage watchIndex(Optional<String> watchIndex) {
            this.watchIndex = watchIndex;
            return this;
        }

        @Override
        public GetDeviceLinkRequest build() {
            return new GetDeviceLinkRequest(this.deviceLinkToken, this.watchIndex);
        }
    }

    public static interface _FinalStage {
        public GetDeviceLinkRequest build();

        public _FinalStage watchIndex(Optional<String> var1);

        public _FinalStage watchIndex(String var1);
    }

    public static interface DeviceLinkTokenStage {
        public _FinalStage deviceLinkToken(String var1);

        public Builder from(GetDeviceLinkRequest var1);
    }
}

