/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.LogsPerfMark;
import com.rivet.api.resources.cloud.common.types.LogsPerfSpan;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class SvcPerf {
    private final String svcName;
    private final OffsetDateTime ts;
    private final long duration;
    private final Optional<UUID> reqId;
    private final List<LogsPerfSpan> spans;
    private final List<LogsPerfMark> marks;

    private SvcPerf(String svcName, OffsetDateTime ts, long duration, Optional<UUID> reqId, List<LogsPerfSpan> spans, List<LogsPerfMark> marks) {
        this.svcName = svcName;
        this.ts = ts;
        this.duration = duration;
        this.reqId = reqId;
        this.spans = spans;
        this.marks = marks;
    }

    @JsonProperty(value="svc_name")
    public String getSvcName() {
        return this.svcName;
    }

    @JsonProperty(value="ts")
    public OffsetDateTime getTs() {
        return this.ts;
    }

    @JsonProperty(value="duration")
    public long getDuration() {
        return this.duration;
    }

    @JsonProperty(value="req_id")
    public Optional<UUID> getReqId() {
        return this.reqId;
    }

    @JsonProperty(value="spans")
    public List<LogsPerfSpan> getSpans() {
        return this.spans;
    }

    @JsonProperty(value="marks")
    public List<LogsPerfMark> getMarks() {
        return this.marks;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SvcPerf && this.equalTo((SvcPerf)other);
    }

    private boolean equalTo(SvcPerf other) {
        return this.svcName.equals(other.svcName) && this.ts.equals(other.ts) && this.duration == other.duration && this.reqId.equals(other.reqId) && this.spans.equals(other.spans) && this.marks.equals(other.marks);
    }

    public int hashCode() {
        return Objects.hash(this.svcName, this.ts, this.duration, this.reqId, this.spans, this.marks);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SvcNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SvcNameStage,
    TsStage,
    DurationStage,
    _FinalStage {
        private String svcName;
        private OffsetDateTime ts;
        private long duration;
        private List<LogsPerfMark> marks = new ArrayList<LogsPerfMark>();
        private List<LogsPerfSpan> spans = new ArrayList<LogsPerfSpan>();
        private Optional<UUID> reqId = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(SvcPerf other) {
            this.svcName(other.getSvcName());
            this.ts(other.getTs());
            this.duration(other.getDuration());
            this.reqId(other.getReqId());
            this.spans(other.getSpans());
            this.marks(other.getMarks());
            return this;
        }

        @Override
        @JsonSetter(value="svc_name")
        public TsStage svcName(String svcName) {
            this.svcName = svcName;
            return this;
        }

        @Override
        @JsonSetter(value="ts")
        public DurationStage ts(OffsetDateTime ts) {
            this.ts = ts;
            return this;
        }

        @Override
        @JsonSetter(value="duration")
        public _FinalStage duration(long duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public _FinalStage addAllMarks(List<LogsPerfMark> marks) {
            this.marks.addAll(marks);
            return this;
        }

        @Override
        public _FinalStage addMarks(LogsPerfMark marks) {
            this.marks.add(marks);
            return this;
        }

        @Override
        @JsonSetter(value="marks", nulls=Nulls.SKIP)
        public _FinalStage marks(List<LogsPerfMark> marks) {
            this.marks.clear();
            this.marks.addAll(marks);
            return this;
        }

        @Override
        public _FinalStage addAllSpans(List<LogsPerfSpan> spans) {
            this.spans.addAll(spans);
            return this;
        }

        @Override
        public _FinalStage addSpans(LogsPerfSpan spans) {
            this.spans.add(spans);
            return this;
        }

        @Override
        @JsonSetter(value="spans", nulls=Nulls.SKIP)
        public _FinalStage spans(List<LogsPerfSpan> spans) {
            this.spans.clear();
            this.spans.addAll(spans);
            return this;
        }

        @Override
        public _FinalStage reqId(UUID reqId) {
            this.reqId = Optional.of(reqId);
            return this;
        }

        @Override
        @JsonSetter(value="req_id", nulls=Nulls.SKIP)
        public _FinalStage reqId(Optional<UUID> reqId) {
            this.reqId = reqId;
            return this;
        }

        @Override
        public SvcPerf build() {
            return new SvcPerf(this.svcName, this.ts, this.duration, this.reqId, this.spans, this.marks);
        }
    }

    public static interface _FinalStage {
        public SvcPerf build();

        public _FinalStage reqId(Optional<UUID> var1);

        public _FinalStage reqId(UUID var1);

        public _FinalStage spans(List<LogsPerfSpan> var1);

        public _FinalStage addSpans(LogsPerfSpan var1);

        public _FinalStage addAllSpans(List<LogsPerfSpan> var1);

        public _FinalStage marks(List<LogsPerfMark> var1);

        public _FinalStage addMarks(LogsPerfMark var1);

        public _FinalStage addAllMarks(List<LogsPerfMark> var1);
    }

    public static interface DurationStage {
        public _FinalStage duration(long var1);
    }

    public static interface TsStage {
        public DurationStage ts(OffsetDateTime var1);
    }

    public static interface SvcNameStage {
        public TsStage svcName(String var1);

        public Builder from(SvcPerf var1);
    }
}

