/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class NamespaceVersion {
    private final String namespaceId;
    private final String versionId;
    private final OffsetDateTime deployTs;

    private NamespaceVersion(String namespaceId, String versionId, OffsetDateTime deployTs) {
        this.namespaceId = namespaceId;
        this.versionId = versionId;
        this.deployTs = deployTs;
    }

    @JsonProperty(value="namespace_id")
    public String getNamespaceId() {
        return this.namespaceId;
    }

    @JsonProperty(value="version_id")
    public String getVersionId() {
        return this.versionId;
    }

    @JsonProperty(value="deploy_ts")
    public OffsetDateTime getDeployTs() {
        return this.deployTs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NamespaceVersion && this.equalTo((NamespaceVersion)other);
    }

    private boolean equalTo(NamespaceVersion other) {
        return this.namespaceId.equals(other.namespaceId) && this.versionId.equals(other.versionId) && this.deployTs.equals(other.deployTs);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.versionId, this.deployTs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NamespaceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NamespaceIdStage,
    VersionIdStage,
    DeployTsStage,
    _FinalStage {
        private String namespaceId;
        private String versionId;
        private OffsetDateTime deployTs;

        private Builder() {
        }

        @Override
        public Builder from(NamespaceVersion other) {
            this.namespaceId(other.getNamespaceId());
            this.versionId(other.getVersionId());
            this.deployTs(other.getDeployTs());
            return this;
        }

        @Override
        @JsonSetter(value="namespace_id")
        public VersionIdStage namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        @JsonSetter(value="version_id")
        public DeployTsStage versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        @JsonSetter(value="deploy_ts")
        public _FinalStage deployTs(OffsetDateTime deployTs) {
            this.deployTs = deployTs;
            return this;
        }

        @Override
        public NamespaceVersion build() {
            return new NamespaceVersion(this.namespaceId, this.versionId, this.deployTs);
        }
    }

    public static interface _FinalStage {
        public NamespaceVersion build();
    }

    public static interface DeployTsStage {
        public _FinalStage deployTs(OffsetDateTime var1);
    }

    public static interface VersionIdStage {
        public DeployTsStage versionId(String var1);
    }

    public static interface NamespaceIdStage {
        public VersionIdStage namespaceId(String var1);

        public Builder from(NamespaceVersion var1);
    }
}

