/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.NamespaceConfig;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class NamespaceFull {
    private final UUID namespaceId;
    private final OffsetDateTime createTs;
    private final String displayName;
    private final UUID versionId;
    private final String nameId;
    private final NamespaceConfig config;

    private NamespaceFull(UUID namespaceId, OffsetDateTime createTs, String displayName, UUID versionId, String nameId, NamespaceConfig config) {
        this.namespaceId = namespaceId;
        this.createTs = createTs;
        this.displayName = displayName;
        this.versionId = versionId;
        this.nameId = nameId;
        this.config = config;
    }

    @JsonProperty(value="namespace_id")
    public UUID getNamespaceId() {
        return this.namespaceId;
    }

    @JsonProperty(value="create_ts")
    public OffsetDateTime getCreateTs() {
        return this.createTs;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="version_id")
    public UUID getVersionId() {
        return this.versionId;
    }

    @JsonProperty(value="name_id")
    public String getNameId() {
        return this.nameId;
    }

    @JsonProperty(value="config")
    public NamespaceConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NamespaceFull && this.equalTo((NamespaceFull)other);
    }

    private boolean equalTo(NamespaceFull other) {
        return this.namespaceId.equals(other.namespaceId) && this.createTs.equals(other.createTs) && this.displayName.equals(other.displayName) && this.versionId.equals(other.versionId) && this.nameId.equals(other.nameId) && this.config.equals(other.config);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.createTs, this.displayName, this.versionId, this.nameId, this.config);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NamespaceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NamespaceIdStage,
    CreateTsStage,
    DisplayNameStage,
    VersionIdStage,
    NameIdStage,
    ConfigStage,
    _FinalStage {
        private UUID namespaceId;
        private OffsetDateTime createTs;
        private String displayName;
        private UUID versionId;
        private String nameId;
        private NamespaceConfig config;

        private Builder() {
        }

        @Override
        public Builder from(NamespaceFull other) {
            this.namespaceId(other.getNamespaceId());
            this.createTs(other.getCreateTs());
            this.displayName(other.getDisplayName());
            this.versionId(other.getVersionId());
            this.nameId(other.getNameId());
            this.config(other.getConfig());
            return this;
        }

        @Override
        @JsonSetter(value="namespace_id")
        public CreateTsStage namespaceId(UUID namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        @Override
        @JsonSetter(value="create_ts")
        public DisplayNameStage createTs(OffsetDateTime createTs) {
            this.createTs = createTs;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public VersionIdStage displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        @JsonSetter(value="version_id")
        public NameIdStage versionId(UUID versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        @JsonSetter(value="name_id")
        public ConfigStage nameId(String nameId) {
            this.nameId = nameId;
            return this;
        }

        @Override
        @JsonSetter(value="config")
        public _FinalStage config(NamespaceConfig config) {
            this.config = config;
            return this;
        }

        @Override
        public NamespaceFull build() {
            return new NamespaceFull(this.namespaceId, this.createTs, this.displayName, this.versionId, this.nameId, this.config);
        }
    }

    public static interface _FinalStage {
        public NamespaceFull build();
    }

    public static interface ConfigStage {
        public _FinalStage config(NamespaceConfig var1);
    }

    public static interface NameIdStage {
        public ConfigStage nameId(String var1);
    }

    public static interface VersionIdStage {
        public NameIdStage versionId(UUID var1);
    }

    public static interface DisplayNameStage {
        public VersionIdStage displayName(String var1);
    }

    public static interface CreateTsStage {
        public DisplayNameStage createTs(OffsetDateTime var1);
    }

    public static interface NamespaceIdStage {
        public CreateTsStage namespaceId(UUID var1);

        public Builder from(NamespaceFull var1);
    }
}

