/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.PortProtocol;
import com.rivet.api.resources.cloud.version.matchmaker.common.types.PortRange;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class MatchmakerDevelopmentPort {
    private final Optional<Integer> port;
    private final Optional<PortRange> portRange;
    private final PortProtocol protocol;

    private MatchmakerDevelopmentPort(Optional<Integer> port, Optional<PortRange> portRange, PortProtocol protocol) {
        this.port = port;
        this.portRange = portRange;
        this.protocol = protocol;
    }

    @JsonProperty(value="port")
    public Optional<Integer> getPort() {
        return this.port;
    }

    @JsonProperty(value="port_range")
    public Optional<PortRange> getPortRange() {
        return this.portRange;
    }

    @JsonProperty(value="protocol")
    public PortProtocol getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MatchmakerDevelopmentPort && this.equalTo((MatchmakerDevelopmentPort)other);
    }

    private boolean equalTo(MatchmakerDevelopmentPort other) {
        return this.port.equals(other.port) && this.portRange.equals(other.portRange) && this.protocol.equals((Object)other.protocol);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.port, this.portRange, this.protocol});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ProtocolStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ProtocolStage,
    _FinalStage {
        private PortProtocol protocol;
        private Optional<PortRange> portRange = Optional.empty();
        private Optional<Integer> port = Optional.empty();

        private Builder() {
        }

        @Override
        public Builder from(MatchmakerDevelopmentPort other) {
            this.port(other.getPort());
            this.portRange(other.getPortRange());
            this.protocol(other.getProtocol());
            return this;
        }

        @Override
        @JsonSetter(value="protocol")
        public _FinalStage protocol(PortProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public _FinalStage portRange(PortRange portRange) {
            this.portRange = Optional.of(portRange);
            return this;
        }

        @Override
        @JsonSetter(value="port_range", nulls=Nulls.SKIP)
        public _FinalStage portRange(Optional<PortRange> portRange) {
            this.portRange = portRange;
            return this;
        }

        @Override
        public _FinalStage port(Integer port) {
            this.port = Optional.of(port);
            return this;
        }

        @Override
        @JsonSetter(value="port", nulls=Nulls.SKIP)
        public _FinalStage port(Optional<Integer> port) {
            this.port = port;
            return this;
        }

        @Override
        public MatchmakerDevelopmentPort build() {
            return new MatchmakerDevelopmentPort(this.port, this.portRange, this.protocol);
        }
    }

    public static interface _FinalStage {
        public MatchmakerDevelopmentPort build();

        public _FinalStage port(Optional<Integer> var1);

        public _FinalStage port(Integer var1);

        public _FinalStage portRange(Optional<PortRange> var1);

        public _FinalStage portRange(PortRange var1);
    }

    public static interface ProtocolStage {
        public _FinalStage protocol(PortProtocol var1);

        public Builder from(MatchmakerDevelopmentPort var1);
    }
}

