/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class LogsLobbyStatusStopped {
    private final OffsetDateTime stopTs;
    private final boolean failed;
    private final int exitCode;

    private LogsLobbyStatusStopped(OffsetDateTime stopTs, boolean failed, int exitCode) {
        this.stopTs = stopTs;
        this.failed = failed;
        this.exitCode = exitCode;
    }

    @JsonProperty(value="stop_ts")
    public OffsetDateTime getStopTs() {
        return this.stopTs;
    }

    @JsonProperty(value="failed")
    public boolean getFailed() {
        return this.failed;
    }

    @JsonProperty(value="exit_code")
    public int getExitCode() {
        return this.exitCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LogsLobbyStatusStopped && this.equalTo((LogsLobbyStatusStopped)other);
    }

    private boolean equalTo(LogsLobbyStatusStopped other) {
        return this.stopTs.equals(other.stopTs) && this.failed == other.failed && this.exitCode == other.exitCode;
    }

    public int hashCode() {
        return Objects.hash(this.stopTs, this.failed, this.exitCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static StopTsStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements StopTsStage,
    FailedStage,
    ExitCodeStage,
    _FinalStage {
        private OffsetDateTime stopTs;
        private boolean failed;
        private int exitCode;

        private Builder() {
        }

        @Override
        public Builder from(LogsLobbyStatusStopped other) {
            this.stopTs(other.getStopTs());
            this.failed(other.getFailed());
            this.exitCode(other.getExitCode());
            return this;
        }

        @Override
        @JsonSetter(value="stop_ts")
        public FailedStage stopTs(OffsetDateTime stopTs) {
            this.stopTs = stopTs;
            return this;
        }

        @Override
        @JsonSetter(value="failed")
        public ExitCodeStage failed(boolean failed) {
            this.failed = failed;
            return this;
        }

        @Override
        @JsonSetter(value="exit_code")
        public _FinalStage exitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        @Override
        public LogsLobbyStatusStopped build() {
            return new LogsLobbyStatusStopped(this.stopTs, this.failed, this.exitCode);
        }
    }

    public static interface _FinalStage {
        public LogsLobbyStatusStopped build();
    }

    public static interface ExitCodeStage {
        public _FinalStage exitCode(int var1);
    }

    public static interface FailedStage {
        public ExitCodeStage failed(boolean var1);
    }

    public static interface StopTsStage {
        public FailedStage stopTs(OffsetDateTime var1);

        public Builder from(LogsLobbyStatusStopped var1);
    }
}

