/*
 * Decompiled with CFR 0.152.
 */
package com.rivet.api.resources.cloud.common.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivet.api.core.ObjectMappers;
import com.rivet.api.resources.cloud.common.types.CdnAuthType;
import com.rivet.api.resources.cloud.common.types.CdnNamespaceAuthUser;
import com.rivet.api.resources.cloud.common.types.CdnNamespaceDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=Builder.class)
public final class CdnNamespaceConfig {
    private final boolean enableDomainPublicAuth;
    private final List<CdnNamespaceDomain> domains;
    private final CdnAuthType authType;
    private final List<CdnNamespaceAuthUser> authUserList;

    private CdnNamespaceConfig(boolean enableDomainPublicAuth, List<CdnNamespaceDomain> domains, CdnAuthType authType, List<CdnNamespaceAuthUser> authUserList) {
        this.enableDomainPublicAuth = enableDomainPublicAuth;
        this.domains = domains;
        this.authType = authType;
        this.authUserList = authUserList;
    }

    @JsonProperty(value="enable_domain_public_auth")
    public boolean getEnableDomainPublicAuth() {
        return this.enableDomainPublicAuth;
    }

    @JsonProperty(value="domains")
    public List<CdnNamespaceDomain> getDomains() {
        return this.domains;
    }

    @JsonProperty(value="auth_type")
    public CdnAuthType getAuthType() {
        return this.authType;
    }

    @JsonProperty(value="auth_user_list")
    public List<CdnNamespaceAuthUser> getAuthUserList() {
        return this.authUserList;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CdnNamespaceConfig && this.equalTo((CdnNamespaceConfig)other);
    }

    private boolean equalTo(CdnNamespaceConfig other) {
        return this.enableDomainPublicAuth == other.enableDomainPublicAuth && this.domains.equals(other.domains) && this.authType.equals((Object)other.authType) && this.authUserList.equals(other.authUserList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enableDomainPublicAuth, this.domains, this.authType, this.authUserList});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EnableDomainPublicAuthStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EnableDomainPublicAuthStage,
    AuthTypeStage,
    _FinalStage {
        private boolean enableDomainPublicAuth;
        private CdnAuthType authType;
        private List<CdnNamespaceAuthUser> authUserList = new ArrayList<CdnNamespaceAuthUser>();
        private List<CdnNamespaceDomain> domains = new ArrayList<CdnNamespaceDomain>();

        private Builder() {
        }

        @Override
        public Builder from(CdnNamespaceConfig other) {
            this.enableDomainPublicAuth(other.getEnableDomainPublicAuth());
            this.domains(other.getDomains());
            this.authType(other.getAuthType());
            this.authUserList(other.getAuthUserList());
            return this;
        }

        @Override
        @JsonSetter(value="enable_domain_public_auth")
        public AuthTypeStage enableDomainPublicAuth(boolean enableDomainPublicAuth) {
            this.enableDomainPublicAuth = enableDomainPublicAuth;
            return this;
        }

        @Override
        @JsonSetter(value="auth_type")
        public _FinalStage authType(CdnAuthType authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public _FinalStage addAllAuthUserList(List<CdnNamespaceAuthUser> authUserList) {
            this.authUserList.addAll(authUserList);
            return this;
        }

        @Override
        public _FinalStage addAuthUserList(CdnNamespaceAuthUser authUserList) {
            this.authUserList.add(authUserList);
            return this;
        }

        @Override
        @JsonSetter(value="auth_user_list", nulls=Nulls.SKIP)
        public _FinalStage authUserList(List<CdnNamespaceAuthUser> authUserList) {
            this.authUserList.clear();
            this.authUserList.addAll(authUserList);
            return this;
        }

        @Override
        public _FinalStage addAllDomains(List<CdnNamespaceDomain> domains) {
            this.domains.addAll(domains);
            return this;
        }

        @Override
        public _FinalStage addDomains(CdnNamespaceDomain domains) {
            this.domains.add(domains);
            return this;
        }

        @Override
        @JsonSetter(value="domains", nulls=Nulls.SKIP)
        public _FinalStage domains(List<CdnNamespaceDomain> domains) {
            this.domains.clear();
            this.domains.addAll(domains);
            return this;
        }

        @Override
        public CdnNamespaceConfig build() {
            return new CdnNamespaceConfig(this.enableDomainPublicAuth, this.domains, this.authType, this.authUserList);
        }
    }

    public static interface _FinalStage {
        public CdnNamespaceConfig build();

        public _FinalStage domains(List<CdnNamespaceDomain> var1);

        public _FinalStage addDomains(CdnNamespaceDomain var1);

        public _FinalStage addAllDomains(List<CdnNamespaceDomain> var1);

        public _FinalStage authUserList(List<CdnNamespaceAuthUser> var1);

        public _FinalStage addAuthUserList(CdnNamespaceAuthUser var1);

        public _FinalStage addAllAuthUserList(List<CdnNamespaceAuthUser> var1);
    }

    public static interface AuthTypeStage {
        public _FinalStage authType(CdnAuthType var1);
    }

    public static interface EnableDomainPublicAuthStage {
        public AuthTypeStage enableDomainPublicAuth(boolean var1);

        public Builder from(CdnNamespaceConfig var1);
    }
}

